/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.impl;

import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.workflow.collection.ResourceCollection;
import com.day.cq.workflow.collection.ResourceCollectionManager;
import com.day.cq.workflow.collection.ResourceCollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class WorkflowPackageManagerImpl
implements WorkflowPackageManager {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPackageManagerImpl.class);
    private static final String WORKFLOW_PACKAGE_TEMPLATE = "/libs/cq/workflow/templates/collectionpage";
    private static final String NT_VLT_DEFINITION = "vlt:PackageDefinition";
    private static final String NN_VLT_DEFINITION = "vlt:definition";
    private static final String FILTER_RESOURCE_TYPE = "cq/workflow/components/collection/definition/resourcelist";
    private static final String FILTER_RESOURCE_RESOURCE_TYPE = "cq/workflow/components/collection/definition/resource";
    private static final String WORKFLOW_PAGE_RESOURCE_TYPE = "cq/workflow/components/collection/page";
    private static final String NT_SLING_FOLDER = "sling:Folder";
    private static final String SLING_RESOURCE_TYPE = "resourceType";
    private static final String[] DEFAULT_WF_PACKAGE_TYPES = new String[]{"cq:Page", "cq:PageContent", "dam:Asset"};
    private String[] workflowPackageTypes = DEFAULT_WF_PACKAGE_TYPES;
    @Property(label="Workflow Package Types", description="Node Types allowed by the WF Package. Default: cq:Page, cq:PageContent, dam:Asset", value={"cq:Page", "cq:PageContent", "dam:Asset"})
    public static final String PROP_WF_PACKAGE_TYPES = "wf-package.types";
    @Reference
    private ResourceCollectionManager resourceCollectionManager;

    @Override
    public final Page create(ResourceResolver resourceResolver, String name, String ... paths) throws WCMException, RepositoryException {
        return this.create(resourceResolver, (String)null, name, paths);
    }

    @Override
    public final Page create(ResourceResolver resourceResolver, String bucketSegment, String name, String ... paths) throws WCMException, RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        String bucketPath = "/etc/workflow/packages";
        if (StringUtils.isNotBlank((String)bucketSegment)) {
            bucketPath = bucketPath + "/" + bucketSegment;
        }
        Node shardNode = JcrUtils.getOrCreateByPath((String)bucketPath, (String)NT_SLING_FOLDER, (String)NT_SLING_FOLDER, (Session)session, (boolean)false);
        Page page = pageManager.create(shardNode.getPath(), JcrUtil.createValidName((String)name), WORKFLOW_PACKAGE_TEMPLATE, name, false);
        Resource contentResource = page.getContentResource();
        Node node = JcrUtil.createPath((String)(contentResource.getPath() + "/" + NN_VLT_DEFINITION), (String)NT_VLT_DEFINITION, (Session)session);
        node = JcrUtil.createPath((String)(node.getPath() + "/filter"), (String)"nt:unstructured", (Session)session);
        JcrUtil.setProperty((Node)node, (String)SLING_RESOURCE_TYPE, (Object)FILTER_RESOURCE_TYPE);
        int i = 0;
        Node resourceNode = null;
        for (String path : paths) {
            if (path == null) continue;
            resourceNode = JcrUtil.createPath((String)(node.getPath() + "/resource_" + i++), (String)"nt:unstructured", (Session)session);
            JcrUtil.setProperty((Node)resourceNode, (String)"root", (Object)path);
            JcrUtil.setProperty((Node)resourceNode, (String)"rules", (Object)this.getIncludeRules(path));
            JcrUtil.setProperty((Node)resourceNode, (String)SLING_RESOURCE_TYPE, (Object)FILTER_RESOURCE_RESOURCE_TYPE);
        }
        session.save();
        return page;
    }

    @Override
    public final List<String> getPaths(ResourceResolver resourceResolver, String path) throws RepositoryException {
        return this.getPaths(resourceResolver, path, this.workflowPackageTypes);
    }

    @Override
    public final List<String> getPaths(ResourceResolver resourceResolver, String path, String[] nodeTypes) throws RepositoryException {
        Node node;
        ResourceCollection resourceCollection;
        ArrayList<String> collectionPaths = new ArrayList<String>();
        Resource resource = resourceResolver.getResource(path);
        if (resource == null) {
            log.warn("Requesting paths for a non-existent Resource [ {} ]; returning empty results.", (Object)path);
            return Collections.EMPTY_LIST;
        }
        if (!this.isWorkflowPackage(resourceResolver, path)) {
            log.debug("Requesting paths for a non-Resource Collection  [ {} ]; returning provided path.", (Object)path);
            return Arrays.asList(path);
        }
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(path);
        if (page != null && page.getContentResource() != null && (resourceCollection = ResourceCollectionUtil.getResourceCollection((Node)(node = (Node)page.getContentResource().adaptTo(Node.class)), (ResourceCollectionManager)this.resourceCollectionManager)) != null) {
            List members = resourceCollection.list(nodeTypes);
            for (Node member : members) {
                collectionPaths.add(member.getPath());
            }
            return collectionPaths;
        }
        return Arrays.asList(path);
    }

    @Override
    public final void delete(ResourceResolver resourceResolver, String path) throws RepositoryException {
        Resource resource = resourceResolver.getResource(path);
        if (resource == null) {
            log.error("Requesting to delete a non-existent Workflow Package [ {} ]", (Object)path);
            return;
        }
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            node.remove();
            node.getSession().save();
        } else {
            log.error("Trying to delete a wf resource [ {} ] that does not resolve to a node.", (Object)resource.getPath());
        }
    }

    @Override
    public final boolean isWorkflowPackage(ResourceResolver resourceResolver, String path) {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page workflowPackagesPage = pageManager.getPage(path);
        if (workflowPackagesPage == null) {
            return false;
        }
        Resource contentResource = workflowPackagesPage.getContentResource();
        if (contentResource == null) {
            return false;
        }
        if (!contentResource.isResourceType(WORKFLOW_PAGE_RESOURCE_TYPE)) {
            return false;
        }
        return contentResource.getChild(NN_VLT_DEFINITION) != null;
    }

    private String[] getIncludeRules(String path) {
        String rootInclude = "include:" + path;
        String contentInclude = "include:" + path + "/jcr:content(/.*)?";
        String[] rules = new String[]{rootInclude, contentInclude};
        return rules;
    }

    @Activate
    protected final void activate(Map<String, String> config) {
        this.workflowPackageTypes = PropertiesUtil.toStringArray((Object)config.get(PROP_WF_PACKAGE_TYPES), (String[])DEFAULT_WF_PACKAGE_TYPES);
    }

    protected void bindResourceCollectionManager(ResourceCollectionManager resourceCollectionManager) {
        this.resourceCollectionManager = resourceCollectionManager;
    }

    protected void unbindResourceCollectionManager(ResourceCollectionManager resourceCollectionManager) {
        if (this.resourceCollectionManager == resourceCollectionManager) {
            this.resourceCollectionManager = null;
        }
    }
}

