/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.replication.Replicator;
import java.util.Calendar;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class PageReplicationStatusModel
implements ReportCellCSVExporter {
    private static final Logger log = LoggerFactory.getLogger(PageReplicationStatusModel.class);
    @OSGiService
    private Replicator replicator;
    @Self
    private Resource resource;

    private Calendar getLastModified(ResourceResolver resourceResolver, String pageContentPath) {
        Resource pageContent = resourceResolver.getResource(pageContentPath);
        Calendar lastModified = null;
        if (pageContent != null) {
            lastModified = (Calendar)pageContent.getValueMap().get("cq:lastModified", Calendar.class);
        }
        return lastModified;
    }

    public String getReplicationStatus() {
        Session session = (Session)this.resource.getResourceResolver().adaptTo(Session.class);
        String path = this.resource.getPath();
        path = path.contains("jcr:content") ? StringUtils.substringAfter((String)path, (String)"jcr:content") + "jcr:content" : path + "/jcr:content";
        log.debug("Getting replication status for {}", (Object)path);
        ReplicationStatus status = this.replicator.getReplicationStatus(session, path);
        Status rStatus = Status.NOT_ACTIVATED;
        if (status != null) {
            if (status.isDeactivated()) {
                rStatus = Status.DEACTIVATED;
            } else if (status.isPending()) {
                rStatus = Status.IN_PROGRESS;
            } else if (status.isActivated()) {
                Calendar lastModified = this.getLastModified(this.resource.getResourceResolver(), path);
                rStatus = lastModified != null && status.getLastPublished() != null && lastModified.after(status.getLastPublished()) ? Status.MODIFIED : Status.ACTIVATED;
            }
        }
        log.debug("Retrieved replication status {}", (Object)rStatus);
        return rStatus.toString();
    }

    @Override
    public String getValue(Object result) {
        return this.getReplicationStatus();
    }

    public static enum Status {
        ACTIVATED,
        DEACTIVATED,
        IN_PROGRESS,
        MODIFIED,
        NOT_ACTIVATED;

    }
}

