/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.visitors;

import com.adobe.acs.commons.functions.CheckedBiConsumer;
import com.adobe.acs.commons.functions.CheckedFunction;
import com.adobe.acs.commons.util.visitors.TraversalException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;

public class SimpleFilteringResourceVisitor {
    TraversalMode mode = TraversalMode.BREADTH;
    CheckedBiConsumer<Map.Entry<String, Object>, Integer> propertyVisitor = null;
    CheckedBiConsumer<Resource, Integer> resourceVisitor = null;
    CheckedBiConsumer<Resource, Integer> leafVisitor = null;
    LinkedList<Resource> stack = new LinkedList();
    CheckedFunction<String, Boolean> propertyFilter = s -> true;
    CheckedFunction<Resource, Boolean> traversalFilter = r -> true;

    public void setPropertyFilter(Function<String, Boolean> filter) {
        this.propertyFilter = CheckedFunction.from(filter);
    }

    public void setPropertyFilterChecked(CheckedFunction<String, Boolean> filter) {
        this.propertyFilter = filter;
    }

    public final void setTraversalFilter(Function<Resource, Boolean> filter) {
        this.traversalFilter = CheckedFunction.from(filter);
    }

    public final void setTraversalFilterChecked(CheckedFunction<Resource, Boolean> filter) {
        this.traversalFilter = filter;
    }

    public final void setResourceVisitor(BiConsumer<Resource, Integer> handler) {
        this.resourceVisitor = CheckedBiConsumer.from(handler);
    }

    public final void setResourceVisitorChecked(CheckedBiConsumer<Resource, Integer> handler) {
        this.resourceVisitor = handler;
    }

    public final void setLeafVisitor(BiConsumer<Resource, Integer> handler) {
        this.leafVisitor = CheckedBiConsumer.from(handler);
    }

    public final void setLeafVisitorChecked(CheckedBiConsumer<Resource, Integer> handler) {
        this.leafVisitor = handler;
    }

    public final void setPropertyVisitor(BiConsumer<Map.Entry<String, Object>, Integer> handler) {
        this.propertyVisitor = CheckedBiConsumer.from(handler);
    }

    public final void setPropertyVisitorChecked(CheckedBiConsumer<Map.Entry<String, Object>, Integer> handler) {
        this.propertyVisitor = handler;
    }

    public final void setBreadthFirstMode() {
        this.mode = TraversalMode.BREADTH;
    }

    public final void setDepthFirstMode() {
        this.mode = TraversalMode.DEPTH;
    }

    public void accept(Resource head) throws TraversalException {
        if (head == null) {
            return;
        }
        this.stack.clear();
        this.stack.add(head);
        int headLevel = SimpleFilteringResourceVisitor.getDepth(head.getPath());
        while (!this.stack.isEmpty()) {
            this.visitNodesInStack(headLevel);
        }
    }

    private void visitNodesInStack(int headLevel) throws TraversalException {
        Resource res = this.stack.poll();
        int level = SimpleFilteringResourceVisitor.getDepth(res.getPath()) - headLevel;
        if (this.propertyVisitor != null) {
            this.visitProperties(res, level);
        }
        try {
            if (this.traversalFilter == null || this.traversalFilter.apply(res).booleanValue()) {
                this.traverseChildren(res, level);
            } else if (this.leafVisitor != null) {
                this.leafVisitor.accept(res, level);
            }
        }
        catch (Exception e) {
            throw new TraversalException(e);
        }
    }

    private void visitProperties(Resource res, int level) throws TraversalException {
        try {
            for (Map.Entry entry : res.getValueMap().entrySet()) {
                if (this.propertyFilter != null && !this.propertyFilter.apply((String)entry.getKey()).booleanValue()) continue;
                this.propertyVisitor.accept(entry, level);
            }
        }
        catch (Exception e) {
            throw new TraversalException(e);
        }
    }

    private void traverseChildren(Resource res, int level) throws TraversalException {
        if (this.resourceVisitor != null) {
            try {
                this.resourceVisitor.accept(res, level);
            }
            catch (Exception e) {
                throw new TraversalException(e);
            }
        }
        switch (this.mode) {
            case BREADTH: {
                this.stack.addAll(SimpleFilteringResourceVisitor.toList(res.getChildren()));
                break;
            }
            default: {
                this.stack.addAll(0, SimpleFilteringResourceVisitor.toList(res.getChildren()));
            }
        }
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    public static int getDepth(String path) {
        return (int)path.chars().filter(c -> c == 47).count() - 1;
    }

    public static enum TraversalMode {
        DEPTH,
        BREADTH;

    }
}

