/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.impl;

import com.adobe.acs.commons.dam.RenditionPatternPicker;
import com.adobe.acs.commons.images.ImageTransformer;
import com.adobe.acs.commons.images.NamedImageTransformer;
import com.adobe.acs.commons.images.impl.ProgressiveJpeg;
import com.adobe.acs.commons.images.impl.SocialImageImpl;
import com.adobe.acs.commons.images.impl.SocialRemoteImageImpl;
import com.adobe.acs.commons.util.PathInfoUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.foundation.Image;
import com.day.image.Layer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Named Transform Image Servlet", description="Transform images programatically by applying a named transform to the requested Image.", metatype=true)
@Properties(value={@Property(label="Resource Types", description="Resource Types and Node Types to bind this servlet to.", name="sling.servlet.resourceTypes", value={"nt/file", "nt/resource", "dam/Asset", "cq/Page", "cq/PageContent", "nt/unstructured", "foundation/components/image", "foundation/components/parbase", "foundation/components/page"}, propertyPrivate=false), @Property(label="Allows Suffix Patterns", description="Regex pattern to filter allowed file names. Defaults to [ (image|img)\\.(.+) ]", name="acs.commons.namedimage.filename.pattern", value={"(image|img)\\.(.+)"}), @Property(label="Extension", description="", name="sling.servlet.extensions", value={"transform"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true)})
@References(value={@Reference(name="namedImageTransformers", referenceInterface=NamedImageTransformer.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE), @Reference(name="imageTransformers", referenceInterface=ImageTransformer.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)})
@Service(value={Servlet.class})
public class NamedTransformImageServlet
extends SlingSafeMethodsServlet
implements OptingServlet {
    private static final Logger log = LoggerFactory.getLogger(NamedTransformImageServlet.class);
    public static final String NAME_IMAGE = "image";
    public static final String NAMED_IMAGE_FILENAME_PATTERN = "acs.commons.namedimage.filename.pattern";
    public static final String DEFAULT_FILENAME_PATTERN = "(image|img)\\.(.+)";
    public static final String RT_LOCAL_SOCIAL_IMAGE = "social:asiFile";
    public static final String RT_REMOTE_SOCIAL_IMAGE = "nt:adobesocialtype";
    private static final ValueMap EMPTY_PARAMS = new ValueMapDecorator(new LinkedHashMap());
    private static final String MIME_TYPE_PNG = "image/png";
    private static final String TYPE_QUALITY = "quality";
    private static final String TYPE_PROGRESSIVE = "progressive";
    private static final String DEFAULT_ASSET_RENDITION_PICKER_REGEX = "cq5dam\\.web\\.(.*)";
    @Property(label="Asset Rendition Picker Regex", description="Regex to select the Rendition to transform when directly transforming a DAM Asset. [ Default: cq5dam.web.(.*) ]", value={"cq5dam\\.web\\.(.*)"})
    private static final String PROP_ASSET_RENDITION_PICKER_REGEX = "prop.asset-rendition-picker-regex";
    private final transient Map<String, NamedImageTransformer> namedImageTransformers = new ConcurrentHashMap<String, NamedImageTransformer>();
    private final transient Map<String, ImageTransformer> imageTransformers = new ConcurrentHashMap<String, ImageTransformer>();
    @Reference
    private transient MimeTypeService mimeTypeService;
    private Pattern lastSuffixPattern = Pattern.compile("(image|img)\\.(.+)");
    private transient RenditionPatternPicker renditionPatternPicker = new RenditionPatternPicker(Pattern.compile("cq5dam\\.web\\.(.*)"));

    public final boolean accepts(SlingHttpServletRequest request) {
        if (request == null) {
            return false;
        }
        String suffix = request.getRequestPathInfo().getSuffix();
        if (StringUtils.isBlank((String)suffix)) {
            return false;
        }
        String transformName = PathInfoUtil.getFirstSuffixSegment(request);
        if (!this.namedImageTransformers.keySet().contains(transformName)) {
            return false;
        }
        String lastSuffix = PathInfoUtil.getLastSuffixSegment(request);
        Matcher matcher = this.lastSuffixPattern.matcher(lastSuffix);
        return matcher.matches();
    }

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        List<NamedImageTransformer> selectedNamedImageTransformers = this.getNamedImageTransformers(request);
        ValueMap imageTransformersWithParams = this.getImageTransformersWithParams(selectedNamedImageTransformers);
        Image image = this.resolveImage(request);
        String mimeType = this.getMimeType(request, image);
        Layer layer = this.getLayer(image);
        if (layer == null) {
            response.setStatus(404);
            return;
        }
        layer = this.transform(layer, imageTransformersWithParams);
        double quality = this.getQuality(mimeType, (ValueMap)imageTransformersWithParams.get(TYPE_QUALITY, (Object)EMPTY_PARAMS));
        boolean progressiveJpeg = this.isProgressiveJpeg(mimeType, (ValueMap)imageTransformersWithParams.get(TYPE_PROGRESSIVE, (Object)EMPTY_PARAMS));
        response.setContentType(mimeType);
        if (progressiveJpeg) {
            ProgressiveJpeg.write(layer, quality, (OutputStream)response.getOutputStream());
        } else {
            layer.write(mimeType, quality, (OutputStream)response.getOutputStream());
        }
        response.flushBuffer();
    }

    protected final Layer transform(Layer layer, ValueMap imageTransformersWithParams) {
        for (String type : imageTransformersWithParams.keySet()) {
            if (StringUtils.equals((String)TYPE_QUALITY, (String)type)) continue;
            ImageTransformer imageTransformer = this.imageTransformers.get(type);
            if (imageTransformer == null) {
                log.warn("Skipping transform. Missing ImageTransformer for type: {}", (Object)type);
                continue;
            }
            ValueMap transformParams = (ValueMap)imageTransformersWithParams.get(type, (Object)EMPTY_PARAMS);
            if (transformParams == null) continue;
            layer = imageTransformer.transform(layer, transformParams);
        }
        return layer;
    }

    protected final List<NamedImageTransformer> getNamedImageTransformers(SlingHttpServletRequest request) {
        ArrayList<NamedImageTransformer> transformers = new ArrayList<NamedImageTransformer>();
        Object[] suffixes = PathInfoUtil.getSuffixSegments(request);
        if (suffixes.length < 2) {
            log.warn("Named Transform Image Servlet requires at least one named transform");
            return transformers;
        }
        int endIndex = suffixes.length - 1;
        if (StringUtils.isNumeric((String)PathInfoUtil.getSuffixSegment(request, suffixes.length - 2))) {
            --endIndex;
        }
        for (Object transformerName : suffixes = (String[])ArrayUtils.subarray((Object[])suffixes, (int)0, (int)endIndex)) {
            NamedImageTransformer transformer = this.namedImageTransformers.get(transformerName);
            if (transformer == null) continue;
            transformers.add(transformer);
        }
        return transformers;
    }

    protected final ValueMap getImageTransformersWithParams(List<NamedImageTransformer> selectedNamedImageTransformers) {
        ValueMapDecorator params = new ValueMapDecorator(new LinkedHashMap());
        for (NamedImageTransformer namedImageTransformer : selectedNamedImageTransformers) {
            params.putAll(namedImageTransformer.getImageTransforms());
        }
        return params;
    }

    protected final Image resolveImage(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        if (DamUtil.isAsset((Resource)resource)) {
            return this.resolveImageAsAsset(resource);
        }
        if (DamUtil.isRendition((Resource)resource) || resource.isResourceType("nt:file") || resource.isResourceType("nt:resource")) {
            Image image = new Image(resource);
            image.set("fileReference", resource.getPath());
            return image;
        }
        ResourceResolver resourceResolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(resource);
        if (page != null) {
            return this.resolveImageAsPage(page, resource);
        }
        if (resource.isResourceType(RT_LOCAL_SOCIAL_IMAGE) && ((String)resource.getValueMap().get("mimetype", (Object)"")).startsWith("image/")) {
            return new SocialImageImpl(resource, NAME_IMAGE);
        }
        if (resource.isResourceType(RT_REMOTE_SOCIAL_IMAGE)) {
            return new SocialRemoteImageImpl(resource, NAME_IMAGE);
        }
        return new Image(resource);
    }

    private Image resolveImageAsAsset(Resource resource) {
        Asset asset = DamUtil.resolveToAsset((Resource)resource);
        Rendition rendition = asset.getRendition((RenditionPicker)this.renditionPatternPicker);
        if (rendition == null) {
            log.warn("Could not find rendition [ {} ] for [ {} ]", (Object)this.renditionPatternPicker, (Object)resource.getPath());
            rendition = asset.getOriginal();
        }
        Resource renditionResource = resource.getResourceResolver().getResource(rendition.getPath());
        Image image = new Image(resource);
        image.set("fileReference", renditionResource.getPath());
        return image;
    }

    private Image resolveImageAsPage(Page page, Resource resource) {
        Resource contentResource = page.getContentResource();
        if (resource.isResourceType("cq:Page") || StringUtils.equals((String)resource.getPath(), (String)contentResource.getPath())) {
            Page current;
            for (current = page; current != null && current.getContentResource(NAME_IMAGE) == null; current = current.getParent()) {
            }
            if (current != null) {
                contentResource = current.getContentResource();
            }
            return new Image(contentResource, NAME_IMAGE);
        }
        return new Image(resource);
    }

    private String getMimeType(SlingHttpServletRequest request, Image image) {
        String lastSuffix = PathInfoUtil.getLastSuffixSegment(request);
        String mimeType = this.mimeTypeService.getMimeType(lastSuffix);
        if (!StringUtils.endsWithIgnoreCase((String)lastSuffix, (String)".orig") && !StringUtils.endsWithIgnoreCase((String)lastSuffix, (String)".original") && ImageIO.getImageWritersByMIMEType(mimeType).hasNext()) {
            return mimeType;
        }
        try {
            return image.getMimeType();
        }
        catch (RepositoryException e) {
            return MIME_TYPE_PNG;
        }
    }

    private Layer getLayer(Image image) throws IOException {
        Layer layer = null;
        try {
            layer = image.getLayer(false, false, false);
        }
        catch (RepositoryException ex) {
            log.error("Could not create layer");
        }
        if (layer == null) {
            log.error("Could not create layer - layer is null;");
        } else {
            image.crop(layer);
            image.rotate(layer);
        }
        return layer;
    }

    protected final double getQuality(String mimeType, ValueMap transforms) {
        String key = TYPE_QUALITY;
        int defaultQuality = 82;
        int maxQuality = 100;
        boolean minQuality = false;
        int maxQualityGif = 255;
        double oneHundred = 100.0;
        log.debug("Transforming with [ quality ]");
        double quality = ((Integer)transforms.get(TYPE_QUALITY, (Object)82)).intValue();
        if (quality > 100.0 || quality < 0.0) {
            quality = 82.0;
        }
        quality /= 100.0;
        if (StringUtils.equals((String)"image/gif", (String)mimeType)) {
            quality *= 255.0;
        }
        return quality;
    }

    protected boolean isProgressiveJpeg(String mimeType, ValueMap transforms) {
        boolean enabled = (Boolean)transforms.get("enabled", (Object)false);
        if (enabled) {
            if ("image/jpeg".equals(mimeType) || "image/jpg".equals(mimeType)) {
                return true;
            }
            log.debug("Progressive encoding is only supported for JPEGs. Mime type: {}", (Object)mimeType);
            return false;
        }
        return false;
    }

    @Activate
    protected final void activate(Map<String, String> properties) {
        String regex = PropertiesUtil.toString((Object)properties.get(PROP_ASSET_RENDITION_PICKER_REGEX), (String)DEFAULT_ASSET_RENDITION_PICKER_REGEX);
        String fileNameRegex = PropertiesUtil.toString((Object)properties.get(NAMED_IMAGE_FILENAME_PATTERN), (String)DEFAULT_FILENAME_PATTERN);
        if (StringUtils.isNotEmpty((String)fileNameRegex)) {
            this.lastSuffixPattern = Pattern.compile(fileNameRegex);
        }
        try {
            this.renditionPatternPicker = new RenditionPatternPicker(regex);
            log.info("Asset Rendition Pattern Picker: {}", (Object)regex);
        }
        catch (Exception ex) {
            log.error("Error creating RenditionPatternPicker with regex [ {} ], defaulting to [ {} ]", (Object)regex, (Object)DEFAULT_ASSET_RENDITION_PICKER_REGEX);
            this.renditionPatternPicker = new RenditionPatternPicker(DEFAULT_ASSET_RENDITION_PICKER_REGEX);
        }
    }

    protected final void bindNamedImageTransformers(NamedImageTransformer service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("name"), null);
        if (type != null) {
            this.namedImageTransformers.put(type, service);
        }
    }

    protected final void unbindNamedImageTransformers(NamedImageTransformer service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("name"), null);
        if (type != null) {
            this.namedImageTransformers.remove(type);
        }
    }

    protected final void bindImageTransformers(ImageTransformer service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("type"), null);
        if (type != null) {
            this.imageTransformers.put(type, service);
        }
    }

    protected final void unbindImageTransformers(ImageTransformer service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("type"), null);
        if (type != null) {
            this.imageTransformers.remove(type);
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

