/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.indesign.dynamicdeckdynamo.models;

import com.adobe.acs.commons.indesign.dynamicdeckdynamo.services.DynamicDeckConfigurationService;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.utils.DynamicDeckUtils;
import com.adobe.acs.commons.mcp.form.SelectComponent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionSelectComponent
extends SelectComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionSelectComponent.class);

    @Override
    public Map<String, String> getOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (null != this.getHelper() && null != this.getHelper().getRequest() && null != this.getHelper().getRequest().getResourceResolver()) {
            ResourceResolver resourceResolver = this.getHelper().getRequest().getResourceResolver();
            DynamicDeckConfigurationService configurationService = (DynamicDeckConfigurationService)this.getHelper().getService(DynamicDeckConfigurationService.class);
            if (null == configurationService) {
                LOGGER.error("Configuration service is null, hence exiting the process and returning empty map");
                return Collections.emptyMap();
            }
            Map<String, String> collectionMap = DynamicDeckUtils.getCollectionsListForLoggedInUser(configurationService.getCollectionQuery(), resourceResolver);
            options.put("", "Select the Collection");
            collectionMap.forEach((key, value) -> options.put((String)value, (String)key));
        } else {
            LOGGER.error("Resource resolver is null while getting the collection list");
        }
        return options;
    }
}

