/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.marketo.client.impl;

import com.adobe.acs.commons.marketo.MarketoClientConfiguration;
import com.adobe.acs.commons.marketo.client.MarketoClient;
import com.adobe.acs.commons.marketo.client.MarketoError;
import com.adobe.acs.commons.marketo.client.MarketoField;
import com.adobe.acs.commons.marketo.client.MarketoForm;
import com.adobe.acs.commons.marketo.client.MarketoResponse;
import com.adobe.acs.commons.marketo.client.impl.MarketoFieldResponse;
import com.adobe.acs.commons.marketo.client.impl.MarketoFormResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MarketoClient.class})
public class MarketoClientImpl
implements MarketoClient {
    private static final Logger log = LoggerFactory.getLogger(MarketoClientImpl.class);
    private static final int PAGE_SIZE = 200;
    private ObjectMapper mapper = new ObjectMapper();

    /*
     * Exception decompiling
     */
    @Nonnull
    protected String getApiResponse(@Nonnull String url, String bearerToken) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Nonnull
    public String getApiToken(@Nonnull MarketoClientConfiguration config) throws IOException {
        log.trace("getApiToken");
        String url = String.format("https://%s/identity/oauth/token?grant_type=client_credentials&client_id=%s&client_secret=%s", config.getEndpointHost(), config.getClientId(), config.getClientSecret());
        String response = this.getApiResponse(url, null);
        Map responseData = (Map)this.mapper.readValue(response, Map.class);
        return (String)responseData.get("access_token");
    }

    @Override
    public List<MarketoField> getFields(MarketoClientConfiguration config) throws IOException {
        MarketoField[] page;
        String apiToken = this.getApiToken(config);
        ArrayList<MarketoField> fields = new ArrayList<MarketoField>();
        String base = String.format("https://%s/rest/asset/v1/form/fields.json?", config.getEndpointHost());
        int i = 0;
        while ((page = (MarketoField[])this.getApiPage(base, apiToken, i, MarketoFieldResponse.class)) != null && page.length != 0) {
            Arrays.stream(page).forEach(fields::add);
            ++i;
        }
        return fields;
    }

    @Nullable
    private <T, R extends MarketoResponse<T>> T[] getApiPage(@Nonnull String urlBase, @Nonnull String token, int page, Class<R> responseType) throws IOException {
        log.trace("getApiPage({})", (Object)page);
        int offset = 200 * page;
        String url = String.format("%smaxReturn=%s&offset=%s", urlBase, 200, offset);
        String responseText = this.getApiResponse(url, token);
        MarketoResponse response = (MarketoResponse)this.mapper.readValue(responseText, responseType);
        if (response.getErrors() != null && response.getErrors().length > 0) {
            throw new IOException("Retrieved errors in response: " + Arrays.stream(response.getErrors()).map(MarketoError::getMessage).collect(Collectors.joining(", ")));
        }
        if (!response.isSuccess()) {
            throw new IOException("Retrieved non-success response");
        }
        return response.getResult();
    }

    @Override
    public List<MarketoForm> getForms(@Nonnull MarketoClientConfiguration config) throws IOException {
        MarketoForm[] page;
        String apiToken = this.getApiToken(config);
        ArrayList<MarketoForm> forms = new ArrayList<MarketoForm>();
        String base = String.format("https://%s/rest/asset/v1/forms.json?status=approved&", config.getEndpointHost());
        int i = 0;
        while ((page = (MarketoForm[])this.getApiPage(base, apiToken, i, MarketoFormResponse.class)) != null && page.length != 0) {
            Arrays.stream(page).forEach(forms::add);
            ++i;
        }
        return forms;
    }
}

