/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import com.adobe.acs.commons.mcp.form.FieldComponent;
import com.adobe.acs.commons.mcp.form.TextfieldComponent;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.osgi.annotation.versioning.ProviderType;

@Target(value={ElementType.FIELD, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@ProviderType
public @interface FormField {
    public String name();

    public String hint() default "";

    public String description() default "";

    public String category() default "";

    public boolean required() default false;

    public Class<? extends FieldComponent> component() default TextfieldComponent.class;

    public String[] options() default {};

    public boolean showOnCreate() default true;

    public static class Factory {
        private Factory() {
        }

        public static FormField create(final String name, final String hint, final String description, final String category, final boolean required, final Class<? extends FieldComponent> clazz, final String[] options) {
            return new FormField(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public String hint() {
                    return hint;
                }

                @Override
                public String description() {
                    return description;
                }

                @Override
                public String category() {
                    return category;
                }

                @Override
                public boolean required() {
                    return required;
                }

                @Override
                public Class<? extends FieldComponent> component() {
                    return clazz;
                }

                @Override
                public String[] options() {
                    return options == null ? new String[]{} : options;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                @Override
                public boolean showOnCreate() {
                    return true;
                }
            };
        }
    }
}

