/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.filter;

import com.adobe.acs.commons.redirects.LocationHeaderAdjuster;
import com.adobe.acs.commons.redirects.filter.RedirectFilterMBean;
import com.adobe.acs.commons.redirects.models.RedirectMatch;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class, RedirectFilterMBean.class, EventHandler.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=A request filter implementing support for virtual redirects", "sling.filter.scope=REQUEST", "service.ranking:Integer=10000", "jmx.objectname=com.adobe.acs.commons:type=Redirect Manager", "event.topics=com/day/cq/replication"})
@Designate(ocd=Configuration.class)
public class RedirectFilter
extends AnnotatedStandardMBean
implements Filter,
EventHandler,
ResourceChangeListener,
RedirectFilterMBean {
    public static final String DEFAULT_STORAGE_PATH = "/conf/acs-commons/redirects";
    public static final String ACS_REDIRECTS_RESOURCE_TYPE = "acs-commons/components/utilities/manage-redirects";
    public static final String REDIRECT_RULE_RESOURCE_TYPE = "acs-commons/components/utilities/manage-redirects/redirect-row";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SERVICE_NAME = "redirect-manager";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private LocationHeaderAdjuster urlAdjuster;
    private ServiceRegistration<?> listenerRegistration;
    private boolean enabled;
    private boolean mapUrls;
    private boolean preserveQueryString;
    private List<Header> onDeliveryHeaders;
    private Collection<String> methods = Arrays.asList("GET", "HEAD");
    private Collection<String> exts;
    private Collection<String> paths;
    private String storagePath;
    private Map<String, RedirectRule> pathRules;
    private Map<Pattern, RedirectRule> patternRules;
    private ExecutorService executor;

    public RedirectFilter() throws NotCompliantMBeanException {
        super(RedirectFilterMBean.class);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Activate
    @Modified
    protected final void activate(Configuration config, BundleContext context) {
        this.enabled = config.enabled();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("resource.paths", config.storagePath());
        this.listenerRegistration = context.registerService(ResourceChangeListener.class, (Object)this, properties);
        log.debug("Registered {}:{}", (Object)"service.id", this.listenerRegistration.getReference().getProperty("service.id"));
        if (this.enabled) {
            this.exts = config.extensions() == null ? Collections.emptySet() : (Collection)Arrays.stream(config.extensions()).filter(ext -> !ext.isEmpty()).collect(Collectors.toSet());
            this.paths = config.paths() == null ? Collections.emptySet() : (Collection)Arrays.stream(config.paths()).filter(path -> !path.isEmpty()).collect(Collectors.toSet());
            this.mapUrls = config.mapUrls();
            this.storagePath = config.storagePath();
            this.onDeliveryHeaders = new ArrayList<Header>();
            for (String kv : config.additionalHeaders()) {
                int idx = kv.indexOf(58);
                if (idx == -1 || idx > kv.length() - 1) {
                    log.error("invalid on-delivery header: {}", (Object)kv);
                    continue;
                }
                String name = kv.substring(0, idx).trim();
                String value = kv.substring(idx + 1).trim();
                this.onDeliveryHeaders.add((Header)new BasicHeader(name, value));
            }
            this.preserveQueryString = config.preserveQueryString();
            log.debug("exts: {}, paths: {}, rewriteUrls: {}, storagePath: {}", new Object[]{this.exts, this.paths, this.mapUrls, this.storagePath});
            this.executor = Executors.newSingleThreadExecutor();
            this.refreshCache();
        }
    }

    @Modified
    protected void modify(BundleContext context, Configuration config) {
        this.deactivate();
        this.activate(config, context);
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdown();
        if (this.listenerRegistration != null) {
            log.debug("unregistering ... ");
            this.listenerRegistration.unregister();
            this.listenerRegistration = null;
        }
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        if (path.startsWith(this.getStoragePath())) {
            log.debug(event.toString());
            this.executor.submit(() -> this.refreshCache());
        }
    }

    public void onChange(List<ResourceChange> changes) {
        boolean changed = changes.stream().anyMatch(e -> e.getPath().startsWith(this.getStoragePath()));
        if (changed) {
            log.debug(changes.toString());
            this.executor.submit(() -> this.refreshCache());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCache() {
        HashMap<String, RedirectRule> pathMatchingRules = new HashMap<String, RedirectRule>();
        LinkedHashMap<Pattern, RedirectRule> patternMatchingRules = new LinkedHashMap<Pattern, RedirectRule>();
        long t0 = System.currentTimeMillis();
        try (ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_NAME));){
            Resource storageResource = resolver.getResource(this.getStoragePath());
            if (storageResource != null) {
                Collection<RedirectRule> rules = RedirectFilter.getRules(storageResource);
                for (RedirectRule rule : rules) {
                    if (rule.getRegex() != null) {
                        patternMatchingRules.put(rule.getRegex(), rule);
                        continue;
                    }
                    pathMatchingRules.put(rule.getSource(), rule);
                }
            }
        }
        catch (LoginException e) {
            log.error("Failed to get resolver for {}", (Object)SERVICE_NAME, (Object)e);
        }
        RedirectFilter redirectFilter = this;
        synchronized (redirectFilter) {
            this.pathRules = pathMatchingRules;
            this.patternRules = patternMatchingRules;
        }
        log.debug("{} rules loaded in {} ms", (Object)(pathMatchingRules.size() + patternMatchingRules.size()), (Object)(System.currentTimeMillis() - t0));
    }

    Map<String, RedirectRule> getPathRules() {
        return this.pathRules;
    }

    Map<Pattern, RedirectRule> getPatternRules() {
        return this.patternRules;
    }

    public static Collection<RedirectRule> getRules(Resource resource) {
        ArrayList<RedirectRule> rules = new ArrayList<RedirectRule>();
        for (Resource res : resource.getChildren()) {
            if (!res.isResourceType(REDIRECT_RULE_RESOURCE_TYPE)) continue;
            rules.add(new RedirectRule(res.getValueMap()));
        }
        return rules;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof SlingHttpServletRequest) || !(response instanceof SlingHttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
        if (this.isEnabled() && this.doesRequestMatch(slingRequest) && this.handleRedirect(slingRequest, slingResponse)) {
            return;
        }
        chain.doFilter(request, response);
    }

    public boolean handleRedirect(SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse) {
        long t0 = System.currentTimeMillis();
        boolean redirected = false;
        RedirectMatch match = this.match(slingRequest);
        if (match != null) {
            RedirectRule redirectRule = match.getRule();
            ZonedDateTime now = ZonedDateTime.now();
            ZonedDateTime untilDateTime = redirectRule.getUntilDateTime();
            if (untilDateTime != null && untilDateTime.isBefore(now)) {
                log.info("redirect rule matched, but expired: {}", (Object)redirectRule.getUntilDate());
            } else {
                RequestPathInfo pathInfo = slingRequest.getRequestPathInfo();
                String resourcePath = pathInfo.getResourcePath();
                log.info("matched {} to {} in {} ms", new Object[]{resourcePath, redirectRule.toString(), System.currentTimeMillis() - t0});
                String location = redirectRule.evaluate(match.getMatcher());
                if (StringUtils.startsWith((String)location, (String)"/") && !StringUtils.startsWith((String)location, (String)"//")) {
                    String queryString;
                    String ext = pathInfo.getExtension();
                    if (ext != null && !location.endsWith(ext)) {
                        location = location + "." + ext;
                    }
                    if (this.mapUrls()) {
                        location = this.mapUrl(location, slingRequest.getResourceResolver());
                    }
                    if (this.preserveQueryString && (queryString = slingRequest.getQueryString()) != null) {
                        int idx = location.indexOf(63);
                        if (idx == -1) {
                            idx = location.indexOf(35);
                        }
                        if (idx != -1) {
                            location = location.substring(0, idx);
                        }
                        location = location + "?" + queryString;
                    }
                    if (this.urlAdjuster != null) {
                        location = this.urlAdjuster.adjust(slingRequest, location);
                    }
                }
                log.info("Redirecting {} to {}, statusCode: {}", new Object[]{resourcePath, location, redirectRule.getStatusCode()});
                slingResponse.setHeader("Location", location);
                for (Header header : this.onDeliveryHeaders) {
                    slingResponse.addHeader(header.getName(), header.getValue());
                }
                slingResponse.setStatus(redirectRule.getStatusCode());
                redirected = true;
            }
        }
        return redirected;
    }

    String mapUrl(String url, ResourceResolver resourceResolver) {
        return resourceResolver.map(url);
    }

    public void destroy() {
    }

    protected boolean mapUrls() {
        return this.mapUrls;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    protected Collection<String> getExtensions() {
        return this.exts;
    }

    protected Collection<String> getPaths() {
        return this.paths;
    }

    protected Collection<String> getMethods() {
        return this.methods;
    }

    protected List<Header> getOnDeliveryHeaders() {
        return this.onDeliveryHeaders;
    }

    private boolean doesRequestMatch(SlingHttpServletRequest request) {
        boolean matches;
        WCMMode wcmMode = WCMMode.fromRequest((ServletRequest)request);
        if (wcmMode != null && wcmMode != WCMMode.DISABLED) {
            log.trace("Request in author mode: {}, no redirection.", (Object)wcmMode);
            return false;
        }
        String method = request.getMethod();
        if (!this.getMethods().contains(method)) {
            log.trace("Request method [{}] does not match any of {}.", (Object)method, this.methods);
            return false;
        }
        String ext = request.getRequestPathInfo().getExtension();
        if (ext != null && !this.getExtensions().isEmpty() && !this.getExtensions().contains(ext)) {
            log.trace("Request extension [{}] does not match any of {}.", (Object)ext, this.exts);
            return false;
        }
        String resourcePath = request.getRequestPathInfo().getResourcePath();
        boolean bl = matches = this.getPaths().isEmpty() || this.getPaths().stream().anyMatch(p -> resourcePath.startsWith(p + "/"));
        if (!matches) {
            log.trace("Request path [{}] not within any of {}.", (Object)resourcePath, this.paths);
            return false;
        }
        return true;
    }

    private static String getResourcePath(RequestPathInfo pathInfo) {
        String resourcePath = pathInfo.getResourcePath();
        int sep = resourcePath.indexOf(46);
        if (sep != -1 && !resourcePath.startsWith("/content/dam/")) {
            resourcePath = resourcePath.substring(0, sep);
        }
        return resourcePath;
    }

    RedirectMatch match(String requestPath) {
        RedirectMatch match = null;
        RedirectRule rule = this.getPathRules().get(requestPath);
        if (rule != null) {
            match = new RedirectMatch(rule, null);
        } else {
            for (Map.Entry<Pattern, RedirectRule> entry : this.getPatternRules().entrySet()) {
                Matcher m = entry.getKey().matcher(requestPath);
                if (!m.matches()) continue;
                match = new RedirectMatch(entry.getValue(), m);
                break;
            }
        }
        return match;
    }

    RedirectMatch match(SlingHttpServletRequest slingRequest) {
        String resourcePath = RedirectFilter.getResourcePath(slingRequest.getRequestPathInfo());
        RedirectMatch rule = this.match(resourcePath);
        if (rule == null) {
            rule = this.match(this.mapUrl(resourcePath, slingRequest.getResourceResolver()));
        }
        return rule;
    }

    @Override
    public TabularData getRedirectConfigurations() throws OpenDataException {
        Map<Pattern, RedirectRule> patternMatchingRules;
        String sourceUrl = "Source Url";
        String targetUrl = "Target Url";
        String statusCode = "Status Code";
        String redirectRules = "Redirect Rules";
        CompositeType cacheEntryType = new CompositeType(redirectRules, redirectRules, new String[]{sourceUrl, targetUrl, statusCode}, new String[]{sourceUrl, targetUrl, statusCode}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType(redirectRules, redirectRules, cacheEntryType, new String[]{sourceUrl}));
        ArrayList<RedirectRule> rules = new ArrayList<RedirectRule>();
        Map<String, RedirectRule> pathMatchingRules = this.getPathRules();
        if (pathMatchingRules != null) {
            rules.addAll(pathMatchingRules.values());
        }
        if ((patternMatchingRules = this.getPatternRules()) != null) {
            rules.addAll(patternMatchingRules.values());
        }
        for (RedirectRule rule : rules) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            row.put(sourceUrl, rule.getSource());
            row.put(targetUrl, rule.getTarget());
            row.put(statusCode, rule.getStatusCode());
            tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        }
        return tabularData;
    }

    @ObjectClassDefinition(name="ACS Commons Redirect Filter")
    public static @interface Configuration {
        @AttributeDefinition(name="Enable Redirect Filter", description="Indicates whether the redirect filter is enabled or not.", type=AttributeType.BOOLEAN)
        public boolean enabled() default true;

        @AttributeDefinition(name="Rewrite Location Header", description="Apply Sling Resource Mappings (/etc/map) to Location header. Use if Location header should rewritten using ResourceResolver#map", type=AttributeType.BOOLEAN)
        public boolean mapUrls() default true;

        @AttributeDefinition(name="Request Extensions", description="List of extensions for which redirection is allowed", type=AttributeType.STRING)
        public String[] extensions() default {};

        @AttributeDefinition(name="Request Paths", description="List of paths for which redirection is allowed", type=AttributeType.STRING)
        public String[] paths() default {"/content"};

        @AttributeDefinition(name="Preserve Query String", description="Preserve query string in redirects", type=AttributeType.BOOLEAN)
        public boolean preserveQueryString() default true;

        @AttributeDefinition(name="Storage Path", description="The path in the repository to store redirect configurations", type=AttributeType.STRING)
        public String storagePath() default "/conf/acs-commons/redirects";

        @AttributeDefinition(name="Additional Response Headers", description="Optional response headers in the name:value format to apply on delivery, e.g. Cache-Control: max-age=3600", type=AttributeType.STRING)
        public String[] additionalHeaders() default {};
    }
}

