/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.twitter.impl;

import com.adobe.acs.commons.twitter.impl.TwitterFeedUpdater;
import com.adobe.acs.commons.util.RunnableOnMaster;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="ACS AEM Commons - Twitter Feed Refresh Scheduler", description="Schedule job which refreshes Twitter Feed components on a recurring basis", policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="scheduler.expression", value={"0 0/15 * * * ?"}, label="Refresh Interval", description="Twitter Feed Refresh interval (Quartz Cron Expression)"), @Property(name="scheduler.concurrent", boolValue={false}, propertyPrivate=true)})
public final class TwitterFeedScheduler
extends RunnableOnMaster {
    private static final Logger log = LoggerFactory.getLogger(TwitterFeedScheduler.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private TwitterFeedUpdater twitterFeedService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnMaster() {
        ResourceResolver resourceResolver = null;
        try {
            log.debug("Master Instance, Running ACS AEM Commons Twitter Feed Scheduler");
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            this.twitterFeedService.updateTwitterFeedComponents(resourceResolver);
        }
        catch (Exception e) {
            log.error("Exception while running TwitterFeedScheduler.", (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
                resourceResolver = null;
            }
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindTwitterFeedService(TwitterFeedUpdater twitterFeedUpdater) {
        this.twitterFeedService = twitterFeedUpdater;
    }

    protected void unbindTwitterFeedService(TwitterFeedUpdater twitterFeedUpdater) {
        if (this.twitterFeedService == twitterFeedUpdater) {
            this.twitterFeedService = null;
        }
    }
}

