/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.twitter.impl;

import com.adobe.acs.commons.twitter.impl.TwitterFeedUpdater;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.URLEntity;
import twitter4j.json.DataObjectFactory;

@Component(immediate=true, label="ACS AEM Commons - Twitter Feed Update Service", metatype=true, description="Service to update Twitter Feed components.")
@Service
public final class TwitterFeedUpdaterImpl
implements TwitterFeedUpdater {
    private static final Logger log = LoggerFactory.getLogger(TwitterFeedUpdaterImpl.class);
    @Reference
    private Replicator replicator;
    @Property(value={"acs-commons/components/content/twitter-feed"}, unbounded=PropertyUnbounded.ARRAY, label="Twitter Feed component paths", description="Component paths for Twitter Feed components.")
    private static final String TWITTER_COMPONENT_PATHS = "twitter.component.paths";
    private String[] twitterComponentPaths = null;

    protected void activate(ComponentContext ctx) {
        Dictionary props = ctx.getProperties();
        this.twitterComponentPaths = PropertiesUtil.toStringArray(props.get(TWITTER_COMPONENT_PATHS));
    }

    @Override
    public void updateTwitterFeedComponents(ResourceResolver resourceResolver) {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        List<Resource> twitterResources = this.findTwitterResources(resourceResolver);
        for (Resource twitterResource : twitterResources) {
            Page page = pageManager.getContainingPage(twitterResource);
            if (page == null) continue;
            Twitter client = (Twitter)page.adaptTo(Twitter.class);
            if (client != null) {
                try {
                    ValueMap properties = twitterResource.getValueMap();
                    String username = (String)properties.get("username", String.class);
                    if (StringUtils.isEmpty((String)username)) continue;
                    log.info("Loading Twitter timeline for user {} for component {}.", (Object)username, (Object)twitterResource.getPath());
                    ResponseList statuses = client.getUserTimeline(username);
                    if (statuses == null) continue;
                    ArrayList<String> tweetsList = new ArrayList<String>(statuses.size());
                    ArrayList<String> jsonList = new ArrayList<String>(statuses.size());
                    for (Status status : statuses) {
                        tweetsList.add(this.processTweet(status));
                        jsonList.add(DataObjectFactory.getRawJSON((Object)status));
                    }
                    if (tweetsList.size() <= 0) continue;
                    ModifiableValueMap map = (ModifiableValueMap)twitterResource.adaptTo(ModifiableValueMap.class);
                    map.put((Object)"tweets", (Object)tweetsList.toArray(new String[tweetsList.size()]));
                    map.put((Object)"tweetsJson", (Object)jsonList.toArray(new String[jsonList.size()]));
                    twitterResource.getResourceResolver().commit();
                    this.handleReplication(pageManager, twitterResource);
                }
                catch (PersistenceException e) {
                    log.error("Exception while updating twitter feed on resource:" + twitterResource.getPath(), (Throwable)e);
                }
                catch (ReplicationException e) {
                    log.error("Exception while replicating twitter feed on resource:" + twitterResource.getPath(), (Throwable)e);
                }
                catch (TwitterException e) {
                    log.error("Exception while loading twitter feed on resource:" + twitterResource.getPath(), (Throwable)e);
                }
                continue;
            }
            log.warn("Twitter component found on {}, but page cannot be adapted to Twitter API. Check Cloud SErvice configuration", (Object)page.getPath());
        }
    }

    private List<Resource> findTwitterResources(ResourceResolver resourceResolver) {
        ArrayList<Resource> twitterResources = new ArrayList<Resource>();
        HashMap<String, String> predicateMap = new HashMap<String, String>();
        predicateMap.put("path", "/content");
        predicateMap.put("property", "sling:resourceType");
        int i = 1;
        for (String path : this.twitterComponentPaths) {
            predicateMap.put("property." + i++ + "_value", path.toString());
        }
        predicateMap.put("p.limit", "-1");
        QueryBuilder queryBuilder = (QueryBuilder)resourceResolver.adaptTo(QueryBuilder.class);
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        Query query = queryBuilder.createQuery(PredicateGroup.create(predicateMap), session);
        SearchResult result = query.getResult();
        Iterator resources = result.getResources();
        while (resources.hasNext()) {
            twitterResources.add((Resource)resources.next());
        }
        return twitterResources;
    }

    private String processTweet(Status status) {
        String tweet = status.getText();
        for (URLEntity entity : status.getURLEntities()) {
            String url = String.format("<a target=\"_blank\" href=\"%s\">%s</a>", entity.getURL(), entity.getURL());
            tweet = tweet.replace(entity.getURL(), url);
        }
        return tweet;
    }

    private void handleReplication(PageManager pageManager, Resource twitterResource) throws ReplicationException {
        if (this.isReplicationEnabled(twitterResource)) {
            Session session = (Session)twitterResource.getResourceResolver().adaptTo(Session.class);
            this.replicator.replicate(session, ReplicationActionType.ACTIVATE, twitterResource.getPath());
        }
    }

    private boolean isReplicationEnabled(Resource twitterResource) {
        ValueMap properties = twitterResource.getValueMap();
        return (Boolean)properties.get("replicate", (Object)false);
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }
}

