/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.api;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class PriceInfo
extends ValueMapDecorator {
    public static final String MIN_QUANTITY = "minQuantity";
    private BigDecimal amount;
    private Currency currency;

    public PriceInfo(BigDecimal amount, Currency currency) {
        super(new HashMap());
        this.amount = amount;
        this.currency = currency;
    }

    public PriceInfo(BigDecimal amount, Locale locale) {
        this(amount, Currency.getInstance(locale));
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public long getQuantity() {
        return (Long)this.get(MIN_QUANTITY, 1L);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getFormattedString() {
        NumberFormat nf = NumberFormat.getCurrencyInstance();
        nf.setCurrency(this.currency);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        return this.amount == null ? "" : nf.format(this.amount);
    }

    public String toString() {
        return this.getFormattedString();
    }
}

