/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionHandler;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.PromotionManager;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.common.AbstractJcrCommerceService;
import com.adobe.cq.commerce.common.PriceFilter;
import com.adobe.cq.commerce.common.promotion.AbstractJcrVoucher;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.Language;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.i18n.I18n;
import com.day.cq.personalization.ContextSessionPersistence;
import com.day.cq.personalization.UserPropertiesUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJcrCommerceSession
implements CommerceSession {
    protected static final Logger log = LoggerFactory.getLogger(AbstractJcrCommerceSession.class);
    protected SlingHttpServletRequest request;
    protected SlingHttpServletResponse response;
    protected Resource resource;
    protected ResourceResolver resolver;
    protected AbstractJcrCommerceService commerceService;
    protected Locale locale = Locale.US;
    protected Locale userLocale = null;
    protected String PN_UNIT_PRICE = "price";
    protected String PN_CURRENCY_CODE = "currencyCode";
    protected String PN_ORDER_ID = "orderId";
    protected NumberFormat formatter = NumberFormat.getCurrencyInstance(this.locale);
    protected RoundingMode roundingMode = RoundingMode.HALF_UP;
    protected BigDecimal PRODUCT_TAX_RATE = new BigDecimal("0.06");
    protected BigDecimal SHIPPING_TAX_RATE = BigDecimal.ZERO;
    protected static final String ORDERS_BASE_PATH = "/etc/commerce/orders/";
    protected static final String ORDERS_PATH_DATE_TEMPLATE = "yyyy/MM/dd";
    protected static final String ORDER_NAME = "order";
    protected List<CommerceSession.CartEntry> cart = new ArrayList<CommerceSession.CartEntry>();
    protected List<AbstractJcrVoucher> vouchers = new ArrayList<AbstractJcrVoucher>();
    protected List<String> activePromotions = new ArrayList<String>();
    protected Map<String, String> orderDetails = new HashMap<String, String>();
    protected List<PriceInfo> prices;

    public AbstractJcrCommerceSession(AbstractJcrCommerceService commerceService, SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) throws CommerceException {
        this.request = request;
        this.response = response;
        this.resource = resource;
        this.resolver = resource.getResourceResolver();
        this.commerceService = commerceService;
        this.loadCart();
        Language lang = commerceService.services.languageManager.getCqLanguage(resource);
        if (lang != null && lang.getLocale().getCountry().length() > 0) {
            this.locale = lang.getLocale();
        } else {
            log.warn("Unable to extract locale from page {}, falling back to default locale {}.", (Object)resource.getPath(), (Object)this.locale);
        }
    }

    AbstractJcrCommerceSession(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    protected void loadCart() throws CommerceException {
        try {
            String promotionCountString;
            String voucherCountString;
            Map cartStore = ContextSessionPersistence.getStore((SlingHttpServletRequest)this.request, (String)"CART", (String)"CommercePersistence");
            String entryCountString = (String)cartStore.get("entryCount");
            if (entryCountString != null && entryCountString.length() > 0) {
                int entryCount = Integer.parseInt(entryCountString);
                for (int i = 0; i < entryCount; ++i) {
                    try {
                        Product product = this.commerceService.getProduct((String)cartStore.get("product" + i));
                        int quantity = Integer.parseInt((String)cartStore.get("quantity" + i));
                        if (quantity <= 0) continue;
                        this.doAddCartEntry(product, quantity);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Unable to load product from cookie: {}", cartStore.get("product" + i));
                    }
                }
            }
            if ((voucherCountString = (String)cartStore.get("voucherCount")) != null && voucherCountString.length() > 0) {
                int voucherCount = Integer.parseInt(voucherCountString);
                for (int i = 0; i < voucherCount; ++i) {
                    try {
                        AbstractJcrVoucher voucher = (AbstractJcrVoucher)this.commerceService.getVoucher((String)cartStore.get("voucher" + i));
                        this.vouchers.add(voucher);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Unable to load voucher from ClientContext: {}", cartStore.get("voucher" + i));
                    }
                }
            }
            if ((promotionCountString = (String)cartStore.get("promotionCount")) != null && promotionCountString.length() > 0) {
                int promotionCount = Integer.parseInt(promotionCountString);
                for (int i = 0; i < promotionCount; ++i) {
                    this.activePromotions.add((String)cartStore.get("promotion" + i));
                }
            }
            this.orderDetails = ContextSessionPersistence.getStore((SlingHttpServletRequest)this.request, (String)"ORDER", (String)"CommercePersistence");
            if (this.orderDetails.get(this.PN_ORDER_ID) == null) {
                this.orderDetails.put(this.PN_ORDER_ID, UUID.randomUUID().toString());
            }
            this.calcOrder();
        }
        catch (Exception e) {
            throw new CommerceException("Failed to load cart from client context: ", e);
        }
    }

    protected void saveCart() throws CommerceException {
        try {
            int i;
            HashMap<String, String> cartStore = new HashMap<String, String>();
            for (CommerceSession.CartEntry entry : this.cart) {
                cartStore.put("product" + entry.getEntryIndex(), entry.getProduct().getPath());
                cartStore.put("quantity" + entry.getEntryIndex(), "" + entry.getQuantity());
            }
            cartStore.put("entryCount", "" + this.getCartEntryCount());
            for (i = 0; i < this.vouchers.size(); ++i) {
                cartStore.put("voucher" + i, this.vouchers.get(i).getPath());
            }
            cartStore.put("voucherCount", String.valueOf(this.vouchers.size()));
            for (i = 0; i < this.activePromotions.size(); ++i) {
                cartStore.put("promotion" + i, this.activePromotions.get(i));
            }
            cartStore.put("promotionCount", String.valueOf(this.activePromotions.size()));
            HashMap<String, Map<String, String>> stores = new HashMap<String, Map<String, String>>();
            stores.put("CART", cartStore);
            stores.put("ORDER", this.orderDetails);
            ContextSessionPersistence.putStores((SlingHttpServletRequest)this.request, (SlingHttpServletResponse)this.response, stores, (String)"CommercePersistence");
        }
        catch (Exception e) {
            throw new CommerceException("Failed to save cart to cookie: ", e);
        }
    }

    @Override
    public void logout() throws CommerceException {
    }

    @Override
    public void setUserLocale(Locale locale) {
        this.userLocale = locale;
    }

    @Override
    public Locale getUserLocale() {
        return this.userLocale;
    }

    @Override
    @Deprecated
    public String getPriceInfo(Product product) throws CommerceException {
        List<PriceInfo> prices = this.getProductPriceInfo(product);
        return prices.size() > 0 ? prices.get(0).getFormattedString() : null;
    }

    @Override
    public List<PriceInfo> getProductPriceInfo(Product product) throws CommerceException {
        return this.getProductPriceInfo(product, null);
    }

    @Override
    public List<PriceInfo> getProductPriceInfo(Product product, Predicate filter) throws CommerceException {
        ArrayList<PriceInfo> prices = new ArrayList<PriceInfo>();
        BigDecimal preTax = product.getProperty(this.PN_UNIT_PRICE, BigDecimal.class);
        if (preTax == null) {
            preTax = BigDecimal.ZERO;
        }
        BigDecimal tax = preTax.multiply(this.PRODUCT_TAX_RATE);
        Currency currency = Currency.getInstance(this.userLocale != null ? this.userLocale : this.locale);
        String currencyCode = currency.getCurrencyCode();
        PriceInfo price = new PriceInfo(preTax, currency);
        price.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "PRE_TAX", currencyCode)));
        prices.add(price);
        price = new PriceInfo(tax, currency);
        price.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "TAX", currencyCode)));
        prices.add(price);
        price = new PriceInfo(preTax.add(tax), currency);
        price.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "POST_TAX", currencyCode)));
        prices.add(price);
        CollectionUtils.filter(prices, (Predicate)filter);
        return prices;
    }

    @Override
    public String getProductPrice(Product product) throws CommerceException {
        return this.getProductPrice(product, null);
    }

    @Override
    public String getProductPrice(Product product, Predicate filter) throws CommerceException {
        List<PriceInfo> prices = this.getProductPriceInfo(product, filter);
        return prices.size() > 0 ? prices.get(0).getFormattedString() : null;
    }

    @Deprecated
    public String getShippingPrice(String method) {
        return new PriceInfo(this.getShipping(method), this.userLocale != null ? this.userLocale : this.locale).getFormattedString();
    }

    @Override
    public int getCartEntryCount() {
        return this.cart.size();
    }

    @Override
    public List<CommerceSession.CartEntry> getCartEntries() {
        return this.cart;
    }

    @Override
    @Deprecated
    public String getCartPreTaxPrice() throws CommerceException {
        return this.getCartPrice(null);
    }

    @Override
    @Deprecated
    public String getCartTax() throws CommerceException {
        return this.getCartPrice(new PriceFilter("TAX"));
    }

    @Override
    @Deprecated
    public String getCartTotalPrice() throws CommerceException {
        return this.getCartPrice(new PriceFilter("POST_TAX"));
    }

    @Override
    @Deprecated
    public String getOrderShipping() throws CommerceException {
        return this.getCartPrice(new PriceFilter("SHIPPING"));
    }

    @Override
    @Deprecated
    public String getOrderTotalTax() throws CommerceException {
        return this.getCartPrice(new PriceFilter("ORDER", "TAX"));
    }

    @Override
    @Deprecated
    public String getOrderTotalPrice() throws CommerceException {
        return this.getCartPrice(new PriceFilter("ORDER"));
    }

    @Override
    public List<PriceInfo> getCartPriceInfo(Predicate filter) {
        if (filter != null) {
            ArrayList<PriceInfo> filteredPrices = new ArrayList<PriceInfo>();
            CollectionUtils.select(this.prices, (Predicate)filter, filteredPrices);
            return filteredPrices;
        }
        return this.prices;
    }

    @Override
    public String getCartPrice(Predicate filter) throws CommerceException {
        List<PriceInfo> prices = this.getCartPriceInfo(filter);
        return prices.isEmpty() ? "" : prices.get(0).getFormattedString();
    }

    @Override
    public void addCartEntry(Product product, int quantity) throws CommerceException {
        this.doAddCartEntry(product, quantity);
        this.calcCart();
        this.saveCart();
    }

    protected void doAddCartEntry(Product product, int quantity) {
        int index = this.cart.size();
        EntryImpl entry = new EntryImpl(index);
        entry.product = product;
        entry.quantity = quantity;
        this.cart.add(entry);
        this.calcEntry(index);
    }

    @Override
    public void modifyCartEntry(int entryNumber, int quantity) throws CommerceException {
        if (entryNumber < this.cart.size()) {
            EntryImpl entry = (EntryImpl)this.cart.get(entryNumber);
            entry.quantity = quantity;
            this.calcEntry(entryNumber);
        }
        this.calcCart();
        this.saveCart();
    }

    @Override
    public void deleteCartEntry(int entryNumber) throws CommerceException {
        if (entryNumber < this.cart.size()) {
            this.cart.remove(entryNumber);
        }
        for (int i = 0; i < this.cart.size(); ++i) {
            EntryImpl entry = (EntryImpl)this.cart.get(i);
            entry.index = i;
        }
        this.calcCart();
        this.saveCart();
    }

    protected void calcEntry(int index) {
        EntryImpl entry = (EntryImpl)this.cart.get(index);
        entry.unitPrice = entry.product.getProperty(this.PN_UNIT_PRICE, BigDecimal.class);
        entry.currencyCode = entry.product.getProperty(this.PN_CURRENCY_CODE, String.class);
        if (entry.unitPrice == null) {
            entry.unitPrice = BigDecimal.ZERO;
            entry.preTaxPrice = BigDecimal.ZERO;
            entry.tax = BigDecimal.ZERO;
            entry.totalPrice = BigDecimal.ZERO;
        } else {
            entry.preTaxPrice = entry.unitPrice.multiply(new BigDecimal(entry.quantity));
            entry.tax = entry.preTaxPrice.multiply(this.PRODUCT_TAX_RATE).setScale(2, this.roundingMode);
            entry.totalPrice = entry.preTaxPrice.add(entry.tax);
        }
        entry.calcPrices();
    }

    private void setPrice(PriceInfo priceInfo, String ... types) {
        if (this.prices == null) {
            this.prices = new ArrayList<PriceInfo>();
        }
        List<String> typeList = Arrays.asList(types);
        int index = this.prices.size();
        for (int i = 0; i < this.prices.size(); ++i) {
            PriceInfo price = this.prices.get(i);
            Set priceTypes = (Set)price.get("com.adobe.cq.commerce.common.PriceFilter.types");
            if (!CollectionUtils.isEqualCollection((Collection)priceTypes, typeList)) continue;
            index = i;
            break;
        }
        priceInfo.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(typeList));
        if (index == this.prices.size()) {
            this.prices.add(priceInfo);
        } else {
            this.prices.set(index, priceInfo);
        }
    }

    protected void calcCart() {
        BigDecimal cartPreTaxPrice = BigDecimal.ZERO;
        BigDecimal cartTax = BigDecimal.ZERO;
        BigDecimal cartTotalPrice = BigDecimal.ZERO;
        Currency currency = Currency.getInstance(this.userLocale != null ? this.userLocale : this.locale);
        String currencyCode = currency.getCurrencyCode();
        List<Promotion> promotions = this.getActivePromotions();
        try {
            for (int i = 0; i < this.cart.size(); ++i) {
                this.calcEntry(i);
                EntryImpl entry = (EntryImpl)this.cart.get(i);
                for (Promotion p : promotions) {
                    try {
                        PromotionHandler ph = (PromotionHandler)p.adaptTo(PromotionHandler.class);
                        PriceInfo discount = ph.applyCartEntryPromotion(this, p, entry);
                        if (discount == null || discount.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                        entry.preTaxPrice = entry.preTaxPrice.subtract(discount.getAmount());
                        entry.tax = entry.preTaxPrice.multiply(this.PRODUCT_TAX_RATE).setScale(2, this.roundingMode);
                        entry.totalPrice = entry.preTaxPrice.add(entry.tax);
                        entry.calcPrices();
                        break;
                    }
                    catch (Exception e) {
                        log.error("Applying cart line item promotion failed: ", (Throwable)e);
                    }
                }
                cartPreTaxPrice = cartPreTaxPrice.add(entry.getPriceInfo(new PriceFilter("PRE_TAX", currencyCode)).get(0).getAmount());
                cartTax = cartTax.add(entry.getPriceInfo(new PriceFilter("TAX", currencyCode)).get(0).getAmount());
                cartTotalPrice = cartTotalPrice.add(entry.getPriceInfo(new PriceFilter("POST_TAX", currencyCode)).get(0).getAmount());
            }
            this.setPrice(new PriceInfo(cartPreTaxPrice, currency), "CART", "PRE_TAX");
            this.setPrice(new PriceInfo(cartTax, currency), "CART", "TAX");
            this.setPrice(new PriceInfo(cartTotalPrice, currency), "CART", "POST_TAX");
        }
        catch (CommerceException e) {
            log.error("Calculating cart failed: ", (Throwable)e);
        }
    }

    public List<Promotion> getActivePromotions() {
        ArrayList<Promotion> promotions = new ArrayList<Promotion>(this.activePromotions.size());
        for (String path : this.activePromotions) {
            Promotion p;
            Resource r = this.resolver.getResource(path);
            Promotion promotion = p = r == null ? null : (Promotion)r.adaptTo(Promotion.class);
            if (p == null) {
                log.error("Cart contains promotion with invalid path: " + path);
                continue;
            }
            if (!p.isValid()) continue;
            promotions.add(p);
        }
        for (AbstractJcrVoucher v : this.vouchers) {
            if (!v.isValid(this.request)) continue;
            Promotion p = v.getPromotion();
            if (p == null || !p.isValid()) {
                log.error("Cart contains voucher with invalid promotion: " + v.getPath());
                continue;
            }
            promotions.add(p);
        }
        Collections.sort(promotions, new Comparator<Promotion>(){

            @Override
            public int compare(Promotion p1, Promotion p2) {
                return Long.valueOf(p2.getPriority()).compareTo(p1.getPriority());
            }
        });
        return promotions;
    }

    @Override
    public void addPromotion(String path) throws CommerceException {
        Promotion p;
        Resource r = this.resolver.getResource(path);
        Promotion promotion = p = r == null ? null : (Promotion)r.adaptTo(Promotion.class);
        if (p == null) {
            throw new CommerceException("Invalid promotion path: " + path);
        }
        this.activePromotions.add(p.getPath());
        this.calcCart();
        this.saveCart();
    }

    @Override
    public void removePromotion(String path) throws CommerceException {
        this.activePromotions.remove(path);
        this.calcCart();
        this.saveCart();
    }

    @Override
    public List<PromotionInfo> getPromotions() throws CommerceException {
        ArrayList<PromotionInfo> promotions = new ArrayList<PromotionInfo>(0);
        for (String path : this.activePromotions) {
            String message;
            Promotion p;
            Resource r = this.resolver.getResource(path);
            Promotion promotion = p = r == null ? null : (Promotion)r.adaptTo(Promotion.class);
            if (p == null) {
                log.error("Cart contains promotion with invalid path: " + path);
                continue;
            }
            PromotionHandler handler = (PromotionHandler)p.adaptTo(PromotionHandler.class);
            String string = message = handler != null ? handler.getMessage(this.request, this, p) : null;
            if (message == null || message.length() == 0) {
                message = p.getDescription();
            }
            promotions.add(new PromotionInfo(path, p.getTitle(), PromotionInfo.PromotionStatus.FIRED, message));
        }
        return promotions;
    }

    protected BigDecimal getShipping(String method) {
        String[][] shippingCosts;
        for (String[] entry : shippingCosts = new String[][]{{"ground", "10.00"}, {"3day", "20.00"}, {"2day", "25.00"}, {"overnight", "40.00"}}) {
            if (!entry[0].equals(method)) continue;
            return new BigDecimal(entry[1]);
        }
        return BigDecimal.ZERO;
    }

    protected void calcOrder() throws CommerceException {
        PriceInfo discount;
        PromotionHandler ph;
        BigDecimal orderShipping;
        this.calcCart();
        Currency currency = Currency.getInstance(this.userLocale != null ? this.userLocale : this.locale);
        PriceInfo cartTax = this.getCartPriceInfo(new PriceFilter("TAX")).get(0);
        PriceInfo cartPreTaxPrice = this.getCartPriceInfo(null).get(0);
        BigDecimal orderSubTotal = cartPreTaxPrice.getAmount();
        try {
            String shippingMethod = this.orderDetails.get("shipping-option");
            orderShipping = this.getShipping(shippingMethod);
        }
        catch (Exception e) {
            orderShipping = BigDecimal.ZERO;
        }
        List<Promotion> promotions = this.getActivePromotions();
        for (Promotion p : promotions) {
            try {
                ph = (PromotionHandler)p.adaptTo(PromotionHandler.class);
                discount = ph.applyOrderPromotion(this, p);
                if (discount == null || discount.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                orderSubTotal = orderSubTotal.subtract(discount.getAmount());
                break;
            }
            catch (Exception e) {
                log.error("Applying order-level promotion failed: ", (Throwable)e);
            }
        }
        for (Promotion p : promotions) {
            try {
                ph = (PromotionHandler)p.adaptTo(PromotionHandler.class);
                discount = ph.applyShippingPromotion(this, p);
                if (discount == null || discount.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                orderShipping = orderShipping.subtract(discount.getAmount());
                break;
            }
            catch (Exception e) {
                log.error("Applying shipping promotion failed: ", (Throwable)e);
            }
        }
        BigDecimal orderShippingTax = orderShipping.multiply(this.SHIPPING_TAX_RATE).setScale(2, this.roundingMode);
        BigDecimal orderTotalTax = cartTax.getAmount().add(orderShippingTax);
        BigDecimal orderTotalPrice = orderSubTotal.add(orderTotalTax.add(orderShipping));
        this.setPrice(new PriceInfo(orderShipping, currency), "SHIPPING", "PRE_TAX");
        this.setPrice(new PriceInfo(orderShippingTax, currency), "SHIPPING", "TAX");
        this.setPrice(new PriceInfo(orderShipping.add(orderShippingTax), currency), "SHIPPING", "POST_TAX");
        this.setPrice(new PriceInfo(orderTotalPrice, currency), "ORDER", "TOTAL");
        this.setPrice(new PriceInfo(orderSubTotal, currency), "ORDER", "SUB_TOTAL");
        this.setPrice(new PriceInfo(orderTotalTax, currency), "ORDER", "TAX");
    }

    @Deprecated
    protected String formatPrice(BigDecimal price) {
        if (price == null) {
            return "";
        }
        return this.formatter.format(price.doubleValue());
    }

    @Override
    public void addVoucher(String code) throws CommerceException {
        PromotionManager pm = (PromotionManager)this.resolver.adaptTo(PromotionManager.class);
        AbstractJcrVoucher voucher = pm.getVoucher(this.request, code);
        if (voucher == null) {
            I18n i18n = new I18n((HttpServletRequest)this.request);
            throw new CommerceException(i18n.get("Invalid coupon code."));
        }
        if (!voucher.isValid(this.request)) {
            throw new CommerceException(voucher.getInvalidMessage(this.request));
        }
        for (AbstractJcrVoucher existingVoucher : this.vouchers) {
            if (!existingVoucher.getCode().equals(voucher.getCode())) continue;
            I18n i18n = new I18n((HttpServletRequest)this.request);
            throw new CommerceException(i18n.get("Coupon already added."));
        }
        this.vouchers.add(voucher);
        this.calcCart();
        this.saveCart();
    }

    @Override
    public void removeVoucher(String code) throws CommerceException {
        for (AbstractJcrVoucher voucher : this.vouchers) {
            if (!voucher.getCode().equals(code)) continue;
            this.vouchers.remove(voucher);
            break;
        }
        this.calcCart();
        this.saveCart();
    }

    @Override
    public List<Voucher> getVouchers() throws CommerceException {
        return new ArrayList<Voucher>(this.vouchers);
    }

    @Override
    public String getOrderId() throws CommerceException {
        return this.orderDetails.get(this.PN_ORDER_ID);
    }

    @Override
    public void updateOrderDetails(Map<String, String> delta) throws CommerceException {
        boolean shippingAddressSame = StringUtils.isNotEmpty((String)delta.get("shippingAddressSameAsBilling"));
        for (Map.Entry<String, String> entry : delta.entrySet()) {
            String key = entry.getKey();
            if (key.equals("shippingAddressSameAsBilling") || key.startsWith("payment.")) continue;
            this.orderDetails.put(key, entry.getValue());
            if (!shippingAddressSame || !key.startsWith("billing.")) continue;
            String shippingKey = key.replace("billing.", "shipping.");
            this.orderDetails.put(shippingKey, entry.getValue());
        }
        this.saveCart();
    }

    @Override
    public void updateOrder(Map<String, Object> delta) throws CommerceException {
        HashMap<String, String> newDelta = new HashMap<String, String>();
        ValueMapDecorator vm = new ValueMapDecorator(delta);
        for (String key : vm.keySet()) {
            String value = (String)vm.get(key, String.class);
            if (value == null) continue;
            newDelta.put(key, value);
        }
        this.updateOrderDetails(newDelta);
    }

    @Override
    public Map<String, String> getOrderDetails() throws CommerceException {
        if (this.orderDetails.isEmpty() || this.orderDetails.size() == 1 && this.orderDetails.containsKey(this.PN_ORDER_ID)) {
            try {
                Session userSession = (Session)this.resolver.adaptTo(Session.class);
                UserProperties userProperties = (UserProperties)this.request.adaptTo(UserProperties.class);
                if (userProperties != null && !UserPropertiesUtil.isAnonymous((UserProperties)userProperties)) {
                    UserManager um = ((JackrabbitSession)userSession).getUserManager();
                    Authorizable authorizable = um.getAuthorizable(userProperties.getAuthorizableID());
                    UserPropertiesManager upm = this.commerceService.services.userPropertiesService.createUserPropertiesManager(this.resolver);
                    UserProperties profile = upm.getUserProperties(authorizable.getID(), "profile");
                    this.orderDetails.put("billing.firstname", profile.getProperty("givenName"));
                    this.orderDetails.put("billing.lastname", profile.getProperty("familyName"));
                    this.orderDetails.put("billing.street1", profile.getProperty("streetAddress"));
                    this.orderDetails.put("billing.city", profile.getProperty("city"));
                    this.orderDetails.put("billing.state", profile.getProperty("region"));
                    this.orderDetails.put("billing.zip", profile.getProperty("postalCode"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.orderDetails;
    }

    @Override
    public Map<String, Object> getOrder() throws CommerceException {
        return new HashMap<String, Object>(this.getOrderDetails());
    }

    @Override
    public void submitOrder(Map<String, String> orderDetailsDelta) throws CommerceException {
        this.orderDetails.putAll(orderDetailsDelta);
        this.saveCompletedOrder();
        this.cart.clear();
        this.vouchers.clear();
        this.orderDetails.clear();
        this.saveCart();
    }

    @Override
    public void placeOrder(Map<String, Object> delta) throws CommerceException {
        HashMap<String, String> newDelta = new HashMap<String, String>();
        ValueMapDecorator vm = new ValueMapDecorator(delta);
        for (String key : vm.keySet()) {
            String value = (String)vm.get(key, String.class);
            if (value == null) continue;
            newDelta.put(key, value);
        }
        this.submitOrder(newDelta);
    }

    protected void initializeCompletedOrderStorage(Session adminSession) throws RepositoryException {
        String ordersNodePath = ORDERS_BASE_PATH.substring(0, ORDERS_BASE_PATH.length() - 1);
        if (!adminSession.nodeExists(ordersNodePath)) {
            JcrUtil.createPath((String)ordersNodePath, (String)"nt:unstructured", (Session)adminSession);
            AccessControlUtils.denyAllToEveryone((Session)adminSession, (String)ordersNodePath);
            adminSession.save();
        }
    }

    protected void saveCompletedOrder() throws CommerceException {
        Session adminSession = null;
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(ORDERS_PATH_DATE_TEMPLATE);
            String orderPath = ORDERS_BASE_PATH + dateFormatter.format(Calendar.getInstance(this.locale).getTime()) + "/" + ORDER_NAME;
            adminSession = this.commerceService.services.slingRepository.loginAdministrative(null);
            this.initializeCompletedOrderStorage(adminSession);
            Node orderNode = JcrUtil.createUniquePath((String)orderPath, (String)"nt:unstructured", (Session)adminSession);
            ArrayList<String> entries = new ArrayList<String>();
            for (CommerceSession.CartEntry entry : this.cart) {
                entries.add(this.serializeCartEntry(entry));
            }
            BigDecimal cartPreTaxPrice = this.getCartPriceInfo(new PriceFilter("PRE_TAX")).get(0).getAmount();
            BigDecimal orderShipping = this.getCartPriceInfo(new PriceFilter("SHIPPING")).get(0).getAmount();
            BigDecimal orderTotalTax = this.getCartPriceInfo(new PriceFilter("ORDER", "TAX")).get(0).getAmount();
            BigDecimal orderTotalPrice = this.getCartPriceInfo(new PriceFilter("ORDER", "TOTAL")).get(0).getAmount();
            orderNode.setProperty("cartItems", entries.toArray(new String[entries.size()]));
            orderNode.setProperty("cartSubtotal", cartPreTaxPrice);
            orderNode.setProperty("orderShipping", orderShipping);
            orderNode.setProperty("orderTotalTax", orderTotalTax);
            orderNode.setProperty("orderTotalPrice", orderTotalPrice);
            ArrayList<String> details = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.orderDetails.entrySet()) {
                String detail = this.serializeOrderDetail(entry.getKey(), entry.getValue());
                if (detail == null) continue;
                details.add(detail);
            }
            orderNode.setProperty("orderDetails", details.toArray(new String[details.size()]));
            ArrayList<String> voucherList = new ArrayList<String>();
            for (AbstractJcrVoucher voucher : this.vouchers) {
                voucherList.add(voucher.getPath());
            }
            orderNode.setProperty("vouchers", voucherList.toArray(new String[voucherList.size()]));
            adminSession.save();
        }
        catch (Exception e) {
            throw new CommerceException("Failed to save completed order: ", e);
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    protected String serializeCartEntry(CommerceSession.CartEntry entry) throws CommerceException {
        return entry.getProduct().getPath() + ";" + entry.getQuantity();
    }

    protected String serializeOrderDetail(String key, String value) throws CommerceException {
        if (key.equals("payment.primary-account-number")) {
            if (value.length() > 4) {
                value = value.substring(0, value.length() - 4).replaceAll("[0-9]", "x") + value.substring(value.length() - 4);
            }
        } else if (key.equals("payment.ccv")) {
            return null;
        }
        return key + "=" + value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntryImpl
    implements CommerceSession.CartEntry {
        private int index;
        private Product product;
        private int quantity;
        private BigDecimal unitPrice;
        private BigDecimal preTaxPrice;
        private BigDecimal tax;
        private BigDecimal totalPrice;
        private String currencyCode;
        private List<PriceInfo> prices;

        public EntryImpl(int index) {
            this.index = index;
        }

        @Override
        public int getEntryIndex() {
            return this.index;
        }

        @Override
        public Product getProduct() throws CommerceException {
            return this.product;
        }

        @Override
        public int getQuantity() {
            return this.quantity;
        }

        @Override
        public String getUnitPrice() {
            try {
                return this.getPriceInfo(new PriceFilter("UNIT")).get(0).getFormattedString();
            }
            catch (CommerceException e) {
                return "";
            }
        }

        @Override
        @Deprecated
        public String getPreTaxPrice() {
            try {
                return this.getPriceInfo(new PriceFilter("LINE", "PRE_TAX")).get(0).getFormattedString();
            }
            catch (CommerceException e) {
                return "";
            }
        }

        @Override
        @Deprecated
        public String getTax() {
            try {
                return this.getPriceInfo(new PriceFilter("LINE", "TAX")).get(0).getFormattedString();
            }
            catch (CommerceException e) {
                return "";
            }
        }

        @Override
        public String getTotalPrice() {
            try {
                return this.getPriceInfo(new PriceFilter("LINE", "POST_TAX")).get(0).getFormattedString();
            }
            catch (CommerceException e) {
                return "";
            }
        }

        @Override
        public List<PriceInfo> getPriceInfo(Predicate filter) throws CommerceException {
            if (filter != null) {
                ArrayList<PriceInfo> filtered = new ArrayList<PriceInfo>();
                CollectionUtils.select(this.prices, (Predicate)filter, filtered);
                return filtered;
            }
            return this.prices;
        }

        @Override
        public String getPrice(Predicate filter) throws CommerceException {
            List<PriceInfo> filtered = this.getPriceInfo(filter);
            if (filtered.size() > 0) {
                return filtered.get(0).getFormattedString();
            }
            return "";
        }

        protected void calcPrices() {
            this.prices = new ArrayList<PriceInfo>();
            Currency currency = Currency.getInstance(AbstractJcrCommerceSession.this.userLocale != null ? AbstractJcrCommerceSession.this.userLocale : AbstractJcrCommerceSession.this.locale);
            String currencyCode = currency.getCurrencyCode();
            PriceInfo price = new PriceInfo(this.preTaxPrice, currency);
            price.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("LINE", "PRE_TAX", currencyCode)));
            this.prices.add(price);
            price = new PriceInfo(this.tax, currency);
            price.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("LINE", "TAX", currencyCode)));
            this.prices.add(price);
            price = new PriceInfo(this.totalPrice, currency);
            price.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("LINE", "POST_TAX", currencyCode)));
            this.prices.add(price);
            price = new PriceInfo(this.unitPrice, currency);
            price.put("com.adobe.cq.commerce.common.PriceFilter.types", new HashSet<String>(Arrays.asList("UNIT", "PRE_TAX", currencyCode)));
            this.prices.add(price);
        }

        @Override
        public <T> T getProperty(String name, Class<T> type) {
            return null;
        }
    }
}

