/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.VariantFilter;
import com.adobe.cq.commerce.common.ComponentInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJcrProduct
extends SlingAdaptable
implements Product {
    protected static final String PN_PRODUCT_TYPE = "cq:commerceType";
    protected static final String PN_PRODUCT_VARIANT_AXES = "cq:productVariantAxes";
    protected static final String PN_PRODUCT_DATA = "productData";
    protected static final String PN_PRODUCT_TITLE = "jcr:title";
    protected static final String PN_PRODUCT_DESCRIPTION = "jcr:description";
    protected static final Logger log = LoggerFactory.getLogger(AbstractJcrProduct.class);
    protected Resource resource;

    public AbstractJcrProduct(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String getPagePath() {
        PageManager pm = (PageManager)this.resource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pm.getContainingPage(this.resource);
        return page != null ? page.getPath() + ".html#" + this.getSKU() : null;
    }

    @Override
    public String getTitle() {
        return this.getProperty(PN_PRODUCT_TITLE, String.class);
    }

    @Override
    public String getDescription() {
        return this.getProperty(PN_PRODUCT_DESCRIPTION, String.class);
    }

    @Override
    public String getImageUrl() {
        try {
            Node node = (Node)this.resource.adaptTo(Node.class);
            if (node.hasNode("image")) {
                return node.getPath() + "/image";
            }
            Node root = node.getSession().getRootNode();
            String productDataPath = (String)ResourceUtil.getValueMap((Resource)this.resource).get(PN_PRODUCT_DATA, String.class);
            if (StringUtils.isNotEmpty((String)productDataPath)) {
                Resource productData = this.resource.getResourceResolver().getResource(productDataPath);
                Node node2 = node = productData != null ? (Node)productData.adaptTo(Node.class) : null;
            }
            while (node != root && !node.hasNode("image")) {
                node = node.getParent();
            }
            if (node.hasNode("image")) {
                return node.getPath() + "/image";
            }
        }
        catch (Exception e) {
            log.error("Error getting product image: ", (Throwable)e);
        }
        return "";
    }

    @Override
    public String getThumbnailUrl() {
        String imageUrl = this.getImageUrl();
        return imageUrl.length() > 0 ? imageUrl + ".thumbnail.jpg" : "";
    }

    @Override
    public String getThumbnailUrl(int width) {
        String imageUrl = this.getImageUrl();
        return imageUrl.length() > 0 ? imageUrl + ".thumbnail." + width + ".jpg" : "";
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Resource productData;
        Object value = null;
        ValueMap map = ResourceUtil.getValueMap((Resource)this.resource);
        if (map.containsKey((Object)name)) {
            return (T)map.get(name, type);
        }
        if (map.containsKey((Object)PN_PRODUCT_DATA)) {
            String productDataPath = (String)map.get(PN_PRODUCT_DATA, String.class);
            productData = this.resource.getResourceResolver().getResource(productDataPath);
            if (productData == null) {
                log.error("Product data not found at [{}].", (Object)productDataPath);
                return null;
            }
        } else {
            productData = this.resource;
        }
        ComponentInheritanceValueMap dataMap = new ComponentInheritanceValueMap(productData);
        return (T)dataMap.getInherited(name, type);
    }

    @Override
    public Iterator<Product> getVariants() throws CommerceException {
        return this.getVariants(null);
    }

    @Override
    public boolean axisIsVariant(String axis) {
        Iterator<String> axes = this.getVariantAxes();
        while (axes.hasNext()) {
            if (!axes.next().equals(axis)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Product> getVariants(VariantFilter filter) throws CommerceException {
        ArrayList<Product> variants = new ArrayList<Product>();
        this.collectVariants(this.getBaseProduct(), filter, variants);
        return variants.iterator();
    }

    @Override
    public Iterator<String> getVariantAxes() {
        String[] axes = this.getProperty(PN_PRODUCT_VARIANT_AXES, String[].class);
        if (axes != null) {
            return Arrays.asList(axes).iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    public Product getBaseProduct() throws CommerceException {
        Resource tempResource = this.resource;
        Node tempNode = (Node)tempResource.adaptTo(Node.class);
        if (!this.nodeIsAProduct(tempNode) && !this.nodeIsAVariant(tempNode)) {
            log.error("Node isn't a product: " + this.resource.getPath());
            return null;
        }
        while (this.nodeIsAVariant(tempNode)) {
            tempResource = this.resource.getResourceResolver().getResource(ResourceUtil.getParent((String)tempResource.getPath()));
            tempNode = (Node)tempResource.adaptTo(Node.class);
        }
        if (this.nodeIsAProduct(tempNode)) {
            CommerceService service = (CommerceService)tempResource.adaptTo(CommerceService.class);
            return service.getProduct(tempResource.getPath());
        }
        log.error("Variant product node [{}] didn't have a product parent.", (Object)this.resource.getPath());
        return null;
    }

    @Override
    public Product getPIMProduct() throws CommerceException {
        Resource productData;
        String productDataPath = (String)ResourceUtil.getValueMap((Resource)this.resource).get(PN_PRODUCT_DATA, String.class);
        if (StringUtils.isNotEmpty((String)productDataPath) && (productData = this.resource.getResourceResolver().getResource(productDataPath)) != null) {
            return (Product)productData.adaptTo(Product.class);
        }
        return null;
    }

    protected boolean nodeIsAVariant(Node node) {
        try {
            return node != null && node.hasProperty(PN_PRODUCT_TYPE) && node.getProperty(PN_PRODUCT_TYPE).getString().equals("variant");
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean nodeIsAProduct(Node node) {
        try {
            return node != null && node.hasProperty(PN_PRODUCT_TYPE) && node.getProperty(PN_PRODUCT_TYPE).getString().equals("product");
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void collectVariants(Product p, VariantFilter filter, List<Product> variants) {
        boolean isLeaf = true;
        Iterator i = this.resource.getResourceResolver().listChildren((Resource)p.adaptTo(Resource.class));
        while (i != null && i.hasNext()) {
            Resource child = (Resource)i.next();
            Node childNode = (Node)child.adaptTo(Node.class);
            if (!this.nodeIsAVariant(childNode)) continue;
            isLeaf = false;
            this.collectVariants((Product)child.adaptTo(Product.class), filter, variants);
        }
        if (isLeaf && (filter == null || filter.includes(p))) {
            variants.add(p);
        }
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        if (type == InheritanceValueMap.class) {
            return (AdapterType)((Object)new ComponentInheritanceValueMap(this.resource));
        }
        Object ret = super.adaptTo(type);
        if (ret == null) {
            ret = this.resource.adaptTo(type);
        }
        return (AdapterType)ret;
    }
}

