/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.common.promotion.AbstractJcrVoucher;
import com.day.cq.wcm.api.Page;
import java.util.Comparator;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommerceHelper {
    public static String mapPathToCurrentLanguage(Page currentPage, String srcPath) {
        String[] pageParts = currentPage.getPath().split("/");
        Object[] srcParts = srcPath.split("/");
        if (pageParts.length > 4 && srcParts.length > 4 && pageParts[0].equals(srcParts[0]) && pageParts[1].equals(srcParts[1]) && pageParts[2].equals(srcParts[2])) {
            srcParts[3] = pageParts[3];
            return StringUtils.join((Object[])srcParts, (String)"/");
        }
        return srcPath;
    }

    public static Comparator<Product> getProductSizeComparator() {
        final String[] letterSizes = new String[]{"XXS", "2XS", "XS", "S", "M", "L", "XL", "XXL", "2XL", "XXXL", "3XL"};
        return new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                double d2;
                double d1;
                String[] parts;
                String size1 = o1.getProperty("size", String.class).toUpperCase();
                String size2 = o2.getProperty("size", String.class).toUpperCase();
                if (size1.contains("\"")) {
                    size1 = size1.replace("\"", "");
                }
                if (size1.indexOf("'") >= 1) {
                    parts = size1.split("'");
                    size1 = parts[0];
                    size1 = parts.length == 1 ? size1 + "00" : (parts[1].length() == 1 ? size1 + "0" + parts[1] : size1 + parts[1]);
                }
                if (size2.contains("\"")) {
                    size2 = size2.replace("\"", "");
                }
                if (size2.indexOf("'") >= 1) {
                    parts = size2.split("'");
                    size2 = parts[0];
                    size2 = parts.length == 1 ? size2 + "00" : (parts[1].length() == 1 ? size2 + "0" + parts[1] : size2 + parts[1]);
                }
                if (NumberUtils.isNumber((String)size1) && NumberUtils.isNumber((String)size2)) {
                    d1 = Double.parseDouble(size1);
                    d2 = Double.parseDouble(size2);
                } else if (CommerceHelper.indexOf(letterSizes, size1) >= 0 && CommerceHelper.indexOf(letterSizes, size2) >= 0) {
                    d1 = CommerceHelper.indexOf(letterSizes, size1);
                    d2 = CommerceHelper.indexOf(letterSizes, size2);
                } else {
                    throw new IllegalArgumentException("Sizes were neither numbers or known letter sizes.");
                }
                return NumberUtils.compare((double)d1, (double)d2);
            }
        };
    }

    private static int indexOf(String[] strings, String op) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(op)) continue;
            return i;
        }
        return -1;
    }

    public static Product findCurrentProduct(Page currentPage) {
        try {
            return CommerceHelper.findProduct(currentPage.getContentResource());
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    protected static Product findProduct(Resource resource) throws RepositoryException {
        ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
        if (((String)props.get("cq:commerceType", (Object)"")).equals("product")) {
            return (Product)resource.adaptTo(Product.class);
        }
        Iterator iter = resource.listChildren();
        while (iter.hasNext()) {
            Product product = CommerceHelper.findProduct((Resource)iter.next());
            if (product == null) continue;
            return product;
        }
        return null;
    }

    public static void writeCart(JSONWriter writer, CommerceSession commerceSession) throws CommerceException, JSONException {
        writer.object();
        writer.key("entries").array();
        for (CommerceSession.CartEntry e : commerceSession.getCartEntries()) {
            writer.object();
            writer.key("title").value((Object)e.getProduct().getTitle());
            writer.key("quantity").value((long)e.getQuantity());
            writer.key("priceFormatted").value((Object)e.getPrice(null));
            writer.key("thumbnail").value((Object)e.getProduct().getThumbnailUrl(32));
            writer.key("page").value((Object)e.getProduct().getPagePath());
            writer.key("path").value((Object)e.getProduct().getPath());
            writer.endObject();
        }
        writer.endArray();
        writer.key("promotions").array();
        for (PromotionInfo p : commerceSession.getPromotions()) {
            if (p.getStatus() != PromotionInfo.PromotionStatus.FIRED) continue;
            writer.object();
            writer.key("title").value((Object)p.getTitle());
            writer.key("message").value((Object)p.getMessage());
            writer.key("path").value((Object)p.getPath());
            writer.key("status").value((Object)p.getStatus().toString());
            writer.endObject();
        }
        writer.endArray();
        writer.key("vouchers").array();
        for (Voucher v : commerceSession.getVouchers()) {
            writer.object();
            if (v instanceof AbstractJcrVoucher) {
                AbstractJcrVoucher jcrVoucher = (AbstractJcrVoucher)v;
                String path = jcrVoucher.getPath();
                writer.key("path").value((Object)jcrVoucher.getPath());
                writer.key("description").value((Object)jcrVoucher.getDescription());
            }
            writer.key("code").value((Object)v.getCode());
            writer.endObject();
        }
        writer.endArray();
        writer.key("totalPrice").value((Object)commerceSession.getCartPrice(null));
        writer.endObject();
    }
}

