/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceFacet;
import com.adobe.cq.commerce.api.CommerceFacetValue;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetParamHelper {
    public static final String PREFIX = "facet_";

    public static String toParams(List<CommerceFacet> facets, String facetId, String valueId) {
        HashMap facetMap = new HashMap();
        for (CommerceFacet facet : facets) {
            ArrayList<String> values = new ArrayList<String>();
            facetMap.put(facet.getId(), values);
            for (CommerceFacetValue commerceFacetValue : facet.getValues()) {
                boolean isToggled;
                boolean bl = isToggled = facet.getId().equals(facetId) && commerceFacetValue.getId().equals(valueId);
                if (facet.isMultiSelect()) {
                    if ((!commerceFacetValue.isSelected() || isToggled) && (commerceFacetValue.isSelected() || !isToggled)) continue;
                    values.add(commerceFacetValue.getId());
                    continue;
                }
                if ((values.size() != 0 || !commerceFacetValue.isSelected() || isToggled) && (commerceFacetValue.isSelected() || !isToggled)) continue;
                values.clear();
                values.add(commerceFacetValue.getId());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : facetMap.entrySet()) {
            for (String string : (List)entry.getValue()) {
                builder.append("&facet_" + URLEncoder.encode((String)entry.getKey()) + "=" + URLEncoder.encode(string));
            }
        }
        return builder.length() > 0 ? builder.substring(1) : "";
    }
}

