/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common.promotion;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJcrVoucher
extends SlingAdaptable
implements Voucher {
    public static final String VOUCHER_RESOURCE_TYPE = "commerce/components/voucher";
    public static final long VOUCHER_DEFAULT_PRIORITY = 100L;
    protected Resource resource;
    protected Page page;

    public AbstractJcrVoucher(Resource resource) throws CommerceException {
        this.resource = resource;
        this.page = (Page)resource.adaptTo(Page.class);
        if (this.page == null || !ResourceUtil.isA((Resource)resource.getChild("jcr:content"), (String)VOUCHER_RESOURCE_TYPE)) {
            throw new CommerceException("Resource is not a JcrVoucher.");
        }
    }

    @Override
    public String getCode() {
        ValueMap properties = (ValueMap)this.resource.adaptTo(ValueMap.class);
        return (String)properties.get("jcr:content/code", String.class);
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getTitle() {
        return this.page.getTitle();
    }

    public String getDescription() {
        return this.page.getDescription();
    }

    public String getMessage() {
        ValueMap properties = (ValueMap)this.resource.adaptTo(ValueMap.class);
        return (String)properties.get("jcr:content/message", (Object)"");
    }

    public long getPriority() {
        for (Page parent = this.page.getParent(); parent != null; parent = parent.getParent()) {
            if (!ResourceUtil.isA((Resource)parent.getContentResource(), (String)"cq/personalization/components/campaignpage")) continue;
            return ((Integer)ResourceUtil.getValueMap((Resource)parent.getContentResource()).get("priority", (Object)100)).intValue();
        }
        return 100L;
    }

    @Override
    public boolean isValid(SlingHttpServletRequest request) {
        for (Page parent = this.page.getParent(); parent != null; parent = parent.getParent()) {
            if (!ResourceUtil.isA((Resource)parent.getContentResource(), (String)"cq/personalization/components/campaignpage")) continue;
            return parent.isValid();
        }
        return false;
    }

    @Override
    public String getInvalidMessage(SlingHttpServletRequest request) {
        I18n i18n = new I18n((HttpServletRequest)request);
        for (Page parent = this.page.getParent(); parent != null; parent = parent.getParent()) {
            if (!ResourceUtil.isA((Resource)parent.getContentResource(), (String)"cq/personalization/components/campaignpage")) continue;
            long time = parent.timeUntilValid();
            if (time > 0L) {
                return i18n.get("Invalid coupon code.");
            }
            if (time >= 0L) continue;
            return i18n.get("Coupon expired.");
        }
        return "";
    }

    public Promotion getPromotion() {
        ValueMap properties = (ValueMap)this.resource.adaptTo(ValueMap.class);
        String promoPath = (String)properties.get("jcr:content/promotion", String.class);
        if (promoPath != null && promoPath.length() > 0) {
            Resource promoResource = this.resource.getResourceResolver().getResource(promoPath);
            return promoResource == null ? null : (Promotion)promoResource.adaptTo(Promotion.class);
        }
        return null;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        if (type == Page.class) {
            return (AdapterType)this.page;
        }
        Object ret = super.adaptTo(type);
        if (ret == null) {
            ret = this.resource.adaptTo(type);
        }
        return (AdapterType)ret;
    }
}

