/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common.promotion;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionHandler;
import com.adobe.cq.commerce.common.CommerceHelper;
import com.adobe.cq.commerce.common.PriceFilter;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.PageManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfectPartnerPromotionHandler
implements PromotionHandler {
    private final Logger log = LoggerFactory.getLogger(PerfectPartnerPromotionHandler.class);
    private ResourceResolverFactory resolverFactory = null;
    Map<String, PairingsCache> promoCache = new HashMap<String, PairingsCache>();

    @Override
    public synchronized PriceInfo applyCartEntryPromotion(CommerceSession commerceSession, Promotion promotion, CommerceSession.CartEntry cartEntry) throws CommerceException {
        ValueMap config = ResourceUtil.getValueMap((Resource)promotion.getConfigResource());
        String discountType = (String)config.get("discountType", (Object)"");
        BigDecimal discountValue = (BigDecimal)config.get("discountValue", (Object)BigDecimal.ZERO);
        String promoPath = promotion.getPath();
        this.validateCache(promoPath);
        if (this.promoCache.get(promoPath).discountValid(cartEntry.getProduct(), commerceSession)) {
            BigDecimal discount = BigDecimal.ZERO;
            PriceInfo unitPrice = cartEntry.getPriceInfo(new PriceFilter("UNIT")).get(0);
            if (discountType.equals("percentage")) {
                discount = discount.add(unitPrice.getAmount().multiply(discountValue.divide(new BigDecimal(100.0))));
            } else if (discountType.equals("absolute")) {
                discount = discount.add(discountValue);
            }
            return new PriceInfo(discount, unitPrice.getCurrency());
        }
        return null;
    }

    @Override
    public PriceInfo applyOrderPromotion(CommerceSession commerceSession, Promotion promotion) throws CommerceException {
        return null;
    }

    @Override
    public PriceInfo applyShippingPromotion(CommerceSession commerceSession, Promotion promotion) throws CommerceException {
        return null;
    }

    @Override
    public synchronized String getMessage(SlingHttpServletRequest request, CommerceSession commerceSession, Promotion promotion) throws CommerceException {
        Product product2;
        Product product1;
        String path2;
        String promoPath = promotion.getPath();
        this.validateCache(promoPath);
        PairingsCache pairingCache = this.promoCache.get(promoPath);
        HashMap<String, String> resolved = new HashMap<String, String>();
        HashMap<String, String> potentials = new HashMap<String, String>();
        pairingCache.characterizeCart(commerceSession, resolved, potentials);
        PageManager pageManager = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
        I18n i18n = new I18n((HttpServletRequest)request);
        String message = "";
        for (String path1 : resolved.keySet()) {
            if (message.length() > 0) {
                message = message + "<br>";
            }
            try {
                path2 = (String)resolved.get(path1);
                product1 = CommerceHelper.findCurrentProduct(pageManager.getPage(path1));
                product2 = CommerceHelper.findCurrentProduct(pageManager.getPage(path2));
                message = message + product1.getTitle() + " + " + product2.getTitle();
            }
            catch (Exception e) {
                message = message + i18n.get("error fetching products");
            }
        }
        for (String path1 : potentials.keySet()) {
            if (message.length() > 0) {
                message = message + "<br>";
            }
            try {
                path2 = (String)potentials.get(path1);
                product1 = CommerceHelper.findCurrentProduct(pageManager.getPage(path1));
                product2 = CommerceHelper.findCurrentProduct(pageManager.getPage(path2));
                message = message + i18n.get("{0} <span class='cq-cc-cart-potential-match'> (suggest {1})</span>", null, new Object[]{product1.getTitle(), product2.getTitle()});
            }
            catch (Exception e) {
                message = message + i18n.get("error fetching products");
            }
        }
        if (message.length() == 0) {
            message = i18n.get("no pairings in cart");
        }
        return message;
    }

    public synchronized void getPotentials(CommerceSession commerceSession, Promotion promotion, Map<String, String> potentials) throws CommerceException {
        String promoPath = promotion.getPath();
        this.validateCache(promoPath);
        PairingsCache pairingCache = this.promoCache.get(promoPath);
        HashMap<String, String> resolved = new HashMap<String, String>();
        pairingCache.characterizeCart(commerceSession, resolved, potentials);
    }

    @Override
    public synchronized void invalidateCaches() {
        this.promoCache.clear();
    }

    private synchronized void validateCache(String promoPath) {
        if (!this.promoCache.containsKey(promoPath)) {
            try {
                PairingsCache pairingsCache = new PairingsCache();
                this.promoCache.put(promoPath, pairingsCache);
                ResourceResolver adminResolver = this.resolverFactory.getAdministrativeResourceResolver(Collections.emptyMap());
                Resource promoResource = adminResolver.getResource(promoPath);
                Resource pairings = promoResource.getChild("jcr:content").getChild("config").getChild("pairings");
                Iterator iterator = pairings.listChildren();
                while (iterator.hasNext()) {
                    ValueMap pair = ResourceUtil.getValueMap((Resource)((Resource)iterator.next()));
                    pairingsCache.addPairing((String)pair.get("firstProductPath", String.class), (String)pair.get("secondProductPath", String.class));
                }
            }
            catch (Exception e) {
                this.log.error("Couldn't construct promotion cache for: " + promoPath, (Throwable)e);
            }
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PairingsCache {
        private Map<String, List<String>> firstProductMap = new HashMap<String, List<String>>();
        private Map<String, List<String>> secondProductMap = new HashMap<String, List<String>>();

        private PairingsCache() {
        }

        public void addPairing(String firstProductPath, String secondProductPath) {
            if (firstProductPath == null || secondProductPath == null) {
                return;
            }
            if (this.firstProductMap.containsKey(firstProductPath)) {
                this.firstProductMap.get(firstProductPath).add(secondProductPath);
            } else {
                ArrayList<String> secondProductList = new ArrayList<String>();
                secondProductList.add(secondProductPath);
                this.firstProductMap.put(firstProductPath, secondProductList);
            }
            if (this.secondProductMap.containsKey(secondProductPath)) {
                this.secondProductMap.get(secondProductPath).add(firstProductPath);
            } else {
                ArrayList<String> firstProductList = new ArrayList<String>();
                firstProductList.add(firstProductPath);
                this.secondProductMap.put(secondProductPath, firstProductList);
            }
        }

        public boolean discountValid(Product product, CommerceSession commerceSession) throws CommerceException {
            String secondProductPath = this.getProductPagePath(product);
            if (this.secondProductMap.containsKey(secondProductPath)) {
                List<String> firstProductList = this.secondProductMap.get(secondProductPath);
                for (String firstProductPath : firstProductList) {
                    if (!this.productInCart(firstProductPath, commerceSession)) continue;
                    return true;
                }
            }
            return false;
        }

        public void characterizeCart(CommerceSession commerceSession, Map<String, String> resolved, Map<String, String> potentials) throws CommerceException {
            for (CommerceSession.CartEntry entry : commerceSession.getCartEntries()) {
                String firstProductPath = this.getProductPagePath(entry.getProduct());
                if (!this.firstProductMap.containsKey(firstProductPath)) continue;
                List<String> secondProductsList = this.firstProductMap.get(firstProductPath);
                boolean match = false;
                for (String secondProductPath : secondProductsList) {
                    if (!this.productInCart(secondProductPath, commerceSession)) continue;
                    resolved.put(firstProductPath, secondProductPath);
                    match = true;
                }
                if (match) continue;
                potentials.put(firstProductPath, secondProductsList.get(0));
            }
        }

        private String getProductPagePath(Product product) {
            String href = product.getPagePath();
            int extension = href.indexOf(".html");
            if (extension > 0) {
                return href.substring(0, extension);
            }
            int fragment = href.indexOf(35);
            if (fragment > 0) {
                return href.substring(0, fragment);
            }
            return href;
        }

        private boolean productInCart(String productPath, CommerceSession commerceSession) throws CommerceException {
            for (CommerceSession.CartEntry entry : commerceSession.getCartEntries()) {
                if (!this.getProductPagePath(entry.getProduct()).equals(productPath)) continue;
                return true;
            }
            return false;
        }
    }
}

