/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.impl;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.common.CommerceHelper;
import com.day.cq.commons.TidyJSONWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientContextCartServlet
extends SlingAllMethodsServlet {
    public static final String TIDY = "tidy";
    private static final Logger log = LoggerFactory.getLogger(ClientContextCartServlet.class);

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String pagePath = request.getParameter("pagePath");
        if (pagePath == null || pagePath.length() == 0) {
            response.sendError(400, "Page path not specified.");
            return;
        }
        Resource resource = request.getResourceResolver().getResource(pagePath);
        if (resource == null) {
            response.sendError(400, "Page path invalid.");
            return;
        }
        JSONObject clientContextCart = null;
        try {
            clientContextCart = new JSONObject(request.getParameter("cart"));
        }
        catch (JSONException e) {
            response.sendError(400, "Cart data not valid: " + e.getMessage());
            return;
        }
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            TidyJSONWriter writer = new TidyJSONWriter((Writer)response.getWriter());
            writer.setTidy("true".equals(request.getParameter(TIDY)));
            CommerceService commerceService = (CommerceService)resource.adaptTo(CommerceService.class);
            if (commerceService != null) {
                CommerceSession commerceSession = commerceService.login(request, response);
                this.updateEntries(clientContextCart, commerceService, commerceSession);
                this.updateVouchers(clientContextCart, commerceSession);
                this.updatePromotions(clientContextCart, commerceSession);
                CommerceHelper.writeCart((JSONWriter)writer, commerceSession);
            } else {
                writer.object().endObject();
            }
        }
        catch (Exception e) {
            response.sendError(500, "Cart update failed: " + e.getMessage());
            log.warn("Could not update cart via ClientContext", (Throwable)e);
        }
    }

    private void updateEntries(JSONObject ccCart, CommerceService commerceService, CommerceSession commerceSession) throws CommerceException, JSONException {
        List<CommerceSession.CartEntry> entries = commerceSession.getCartEntries();
        for (int i = entries.size() - 1; i >= 0; --i) {
            commerceSession.deleteCartEntry(i);
        }
        JSONArray ccEntries = ccCart.optJSONArray("entries");
        for (int i = 0; ccEntries != null && i < ccEntries.length(); ++i) {
            JSONObject ccEntry = ccEntries.getJSONObject(i);
            Product product = commerceService.getProduct(ccEntry.getString("path"));
            int quantity = Integer.parseInt(ccEntry.getString("quantity"));
            if (product == null || quantity <= 0) continue;
            commerceSession.addCartEntry(product, quantity);
        }
    }

    private void updateVouchers(JSONObject ccCart, CommerceSession commerceSession) throws CommerceException, JSONException {
        List<Voucher> vouchers = commerceSession.getVouchers();
        for (int i = vouchers.size() - 1; i >= 0; --i) {
            commerceSession.removeVoucher(vouchers.get(i).getCode());
        }
        JSONArray ccVouchers = ccCart.optJSONArray("vouchers");
        for (int i = 0; ccVouchers != null && i < ccVouchers.length(); ++i) {
            try {
                commerceSession.addVoucher(ccVouchers.getJSONObject(i).getString("code"));
                continue;
            }
            catch (CommerceException e) {
                // empty catch block
            }
        }
    }

    private void updatePromotions(JSONObject ccCart, CommerceSession commerceSession) throws CommerceException, JSONException {
        List<PromotionInfo> promotions = commerceSession.getPromotions();
        for (int i = promotions.size() - 1; i >= 0; --i) {
            commerceSession.removePromotion(promotions.get(i).getPath());
        }
        JSONArray ccPromotions = ccCart.optJSONArray("promotions");
        for (int i = 0; ccPromotions != null && i < ccPromotions.length(); ++i) {
            try {
                commerceSession.addPromotion(ccPromotions.getJSONObject(i).getString("path"));
                continue;
            }
            catch (CommerceException e) {
                // empty catch block
            }
        }
    }
}

