/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.impl;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.CommerceServiceFactory;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionHandler;
import com.adobe.cq.commerce.api.promotion.PromotionManager;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.common.ComponentInheritanceValueMap;
import com.adobe.cq.commerce.impl.promotion.PromotionImpl;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommerceAdapterFactory
implements AdapterFactory {
    private final Logger log = LoggerFactory.getLogger(CommerceAdapterFactory.class);
    private static final Class<Resource> RESOURCE_CLASS = Resource.class;
    private static final Class<ResourceResolver> RESOURCE_RESOLVER_CLASS = ResourceResolver.class;
    private static final Class<CommerceService> COMMERCE_SERVICE_CLASS = CommerceService.class;
    private static final Class<Product> PRODUCT_CLASS = Product.class;
    private static final Class<Promotion> PROMOTION_CLASS = Promotion.class;
    private static final Class<PromotionHandler> PROMOTION_HANDLER_CLASS = PromotionHandler.class;
    private static final Class<PromotionManager> PROMOTION_MANAGER_CLASS = PromotionManager.class;
    private static final Class<Voucher> VOUCHER_CLASS = Voucher.class;
    private static final String COMMERCE_PROVIDER_PROPERTY = "cq:commerceProvider";
    private Map<String, CommerceServiceFactory> factories = Collections.synchronizedMap(new HashMap());
    protected static final String[] ADAPTER_CLASSES = new String[]{COMMERCE_SERVICE_CLASS.getName(), PRODUCT_CLASS.getName(), PROMOTION_CLASS.getName(), PROMOTION_HANDLER_CLASS.getName(), PROMOTION_MANAGER_CLASS.getName(), VOUCHER_CLASS.getName()};
    protected static final String[] ADAPTABLE_CLASSES = new String[]{RESOURCE_CLASS.getName(), RESOURCE_RESOLVER_CLASS.getName()};
    private PromotionManager promotionManager;

    protected void bindFactory(CommerceServiceFactory factory, Map<?, ?> properties) {
        this.factories.put((String)properties.get("commerceProvider"), factory);
    }

    protected void unbindFactory(CommerceServiceFactory factory, Map<?, ?> properties) {
        this.factories.remove((String)properties.get("commerceProvider"));
    }

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        this.log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        String promoType;
        Promotion promo;
        if (type == PRODUCT_CLASS || type == VOUCHER_CLASS || type == COMMERCE_SERVICE_CLASS) {
            CommerceServiceFactory factory;
            Page page = ((PageManager)resource.getResourceResolver().adaptTo(PageManager.class)).getContainingPage(resource);
            ComponentInheritanceValueMap properties = page != null ? new HierarchyNodeInheritanceValueMap(page.getContentResource()) : new ComponentInheritanceValueMap(resource);
            String provider = (String)properties.getInherited(COMMERCE_PROVIDER_PROPERTY, String.class);
            if (provider == null && !this.factories.isEmpty()) {
                provider = this.factories.keySet().iterator().next();
            }
            if ((factory = this.factories.get(provider)) != null) {
                CommerceAdapterFactory commerceAdapterFactory = this;
                synchronized (commerceAdapterFactory) {
                    try {
                        CommerceService cs = factory.getCommerceService(resource);
                        if (type == COMMERCE_SERVICE_CLASS) {
                            return (AdapterType)cs;
                        }
                        if (type == PRODUCT_CLASS) {
                            return (AdapterType)cs.getProduct(resource.getPath());
                        }
                        if (type == VOUCHER_CLASS) {
                            return (AdapterType)cs.getVoucher(resource.getPath());
                        }
                    }
                    catch (CommerceException e) {
                        this.log.error("Could not adapt resource: ", (Throwable)e);
                    }
                }
            }
        } else if (type == PROMOTION_CLASS) {
            try {
                return (AdapterType)new PromotionImpl(resource);
            }
            catch (CommerceException e) {
                this.log.error("Could not adapt resource: ", (Throwable)e);
            }
        } else if (type == PROMOTION_HANDLER_CLASS && (promo = (Promotion)resource.adaptTo(Promotion.class)) != null && (promoType = promo.getType()) != null) {
            return (AdapterType)this.promotionManager.getHandler(promoType);
        }
        this.log.debug("Unable to adapt resource to type {}", (Object)type.getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resolver, Class<AdapterType> type) {
        if (type == PROMOTION_MANAGER_CLASS) {
            return (AdapterType)this.promotionManager;
        }
        this.log.warn("Unable to adapt resolver to requested type {}", (Object)type.getName());
        return null;
    }

    protected void bindPromotionManager(PromotionManager promotionManager) {
        this.promotionManager = promotionManager;
    }

    protected void unbindPromotionManager(PromotionManager promotionManager) {
        if (this.promotionManager == promotionManager) {
            this.promotionManager = null;
        }
    }
}

