/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.impl;

import com.adobe.cq.commerce.api.CommerceServiceFactory;
import com.adobe.granite.xss.XSSAPI;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommerceProvidersServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(CommerceProvidersServlet.class);
    private XSSAPI xssAPI;
    private Map<String, Map<?, ?>> factories = new HashMap();

    protected void bindFactory(CommerceServiceFactory factory, Map<?, ?> properties) {
        String provider = (String)properties.get("commerceProvider");
        this.factories.put(provider, properties);
    }

    protected void unbindFactory(CommerceServiceFactory factory, Map<?, ?> properties) {
        String provider = (String)properties.get("commerceProvider");
        this.factories.remove(provider);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Cache-Control", "no-cache");
            JSONWriter w = new JSONWriter((Writer)response.getWriter());
            w.array();
            for (Map<?, ?> propertyMap : this.factories.values()) {
                String value = (String)propertyMap.get("commerceProvider");
                String label = (String)propertyMap.get("commerceProviderLabel");
                if (label == null) {
                    label = StringUtils.capitalize((String)value);
                }
                w.object().key("value").value((Object)this.xssAPI.encodeForHTMLAttr(value)).key("text").value((Object)this.xssAPI.encodeForHTMLAttr(label)).endObject();
            }
            w.endArray();
        }
        catch (Exception e) {
            log.error("Error while generating JSON list", (Throwable)e);
            response.sendError(500, e.toString());
        }
    }

    protected void bindXssAPI(XSSAPI xSSAPI) {
        this.xssAPI = xSSAPI;
    }

    protected void unbindXssAPI(XSSAPI xSSAPI) {
        if (this.xssAPI == xSSAPI) {
            this.xssAPI = null;
        }
    }
}

