/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.impl.promotion;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.OsgiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotionImpl
extends SlingAdaptable
implements Promotion {
    public static final String PN_PROMOTION_TYPE = "jcr:content/promotionType";
    public static final String PN_PRIORITY = "jcr:content/priority";
    private static final Long DEFAULT_PRIORITY = 100L;
    private static final String CONFIG_RESOURCE_NAME = "jcr:content/config";
    private Resource resource;
    protected Page page;

    public PromotionImpl(Resource resource) throws CommerceException {
        this.resource = resource;
        this.page = (Page)resource.adaptTo(Page.class);
        if (this.page == null || !ResourceUtil.isA((Resource)resource.getChild("jcr:content"), (String)"commerce/components/promotion")) {
            throw new CommerceException("Resource is not a Promotion.");
        }
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public String getTitle() {
        return this.page.getTitle();
    }

    @Override
    public String getDescription() {
        return this.page.getDescription();
    }

    @Override
    public String getType() {
        return (String)ResourceUtil.getValueMap((Resource)this.resource).get(PN_PROMOTION_TYPE, String.class);
    }

    @Override
    public long getPriority() {
        return (Long)ResourceUtil.getValueMap((Resource)this.resource).get(PN_PRIORITY, (Object)DEFAULT_PRIORITY);
    }

    @Override
    public List<String> getSegments() {
        ArrayList<String> segments = new ArrayList<String>();
        for (Page parent = this.page.getParent(); parent != null; parent = parent.getParent()) {
            String[] segs;
            Resource parentContent = parent.getContentResource();
            if (!ResourceUtil.isA((Resource)parentContent, (String)"cq/personalization/components/experiencepage") || (segs = OsgiUtil.toStringArray((Object)ResourceUtil.getValueMap((Resource)parentContent).get((Object)"cq:segments"))) == null) continue;
            segments.addAll(Arrays.asList(segs));
        }
        return segments;
    }

    @Override
    public boolean isValid() {
        for (Page parent = this.page.getParent(); parent != null; parent = parent.getParent()) {
            if (!ResourceUtil.isA((Resource)parent.getContentResource(), (String)"cq/personalization/components/campaignpage")) continue;
            return parent.isValid();
        }
        return false;
    }

    @Override
    public Resource getConfigResource() {
        return this.resource.getChild(CONFIG_RESOURCE_NAME);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        if (type == Page.class) {
            return (AdapterType)this.page;
        }
        Object result = this.resource.adaptTo(type);
        if (result != null) {
            return (AdapterType)result;
        }
        return (AdapterType)super.adaptTo(type);
    }
}

