/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.impl.promotion;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionHandler;
import com.adobe.cq.commerce.api.promotion.PromotionManager;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.common.promotion.AbstractJcrVoucher;
import com.adobe.cq.commerce.impl.promotion.PromotionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotionManagerImpl
implements PromotionManager,
EventListener {
    private final Logger log = LoggerFactory.getLogger(PromotionManagerImpl.class);
    static final String DEFAULT_PROMOTION_ROOT = "/content/campaigns";
    private static final String PROMOTION_ROOT = "cq.commerce.promotion.root";
    private ResourceResolverFactory resolverFactory = null;
    private Map<String, PromotionHandler> promotionHandlers = new HashMap<String, PromotionHandler>();
    private String promotionRoot;
    private ResourceResolver adminResolver;
    private ObservationManager observationManager;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<Promotion> promotionsCache = new ArrayList<Promotion>();
    private boolean cachesDirty = true;
    private Map<String, List<AbstractJcrVoucher>> vouchersCache = new HashMap<String, List<AbstractJcrVoucher>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPromotionHandler(PromotionHandler condition, Map<?, ?> properties) {
        this.lock.writeLock().lock();
        try {
            this.promotionHandlers.put((String)properties.get("commerce.promotion.type"), condition);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPromotionHandler(PromotionHandler condition, Map<?, ?> properties) {
        this.lock.writeLock().lock();
        try {
            this.promotionHandlers.remove((String)properties.get("commerce.promotion.type"));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        this.promotionRoot = OsgiUtil.toString(context.getProperties().get(PROMOTION_ROOT), (String)DEFAULT_PROMOTION_ROOT);
        this.adminResolver = this.resolverFactory.getAdministrativeResourceResolver(Collections.emptyMap());
        Session adminSession = (Session)this.adminResolver.adaptTo(Session.class);
        this.observationManager = adminSession.getWorkspace().getObservationManager();
        this.observationManager.addEventListener((EventListener)this, 63, "/", true, null, null, true);
    }

    protected void deactivate(ComponentContext context) throws RepositoryException {
        if (this.adminResolver != null && this.adminResolver.isLive()) {
            if (this.observationManager != null) {
                this.observationManager.removeEventListener((EventListener)this);
            }
            this.adminResolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void onEvent(EventIterator events) {
        this.lock.writeLock().lock();
        try {
            while (events.hasNext()) {
                Event e = events.nextEvent();
                try {
                    String path = e.getPath();
                    if (!path.startsWith(this.promotionRoot)) continue;
                    this.cachesDirty = true;
                    for (PromotionHandler handler : this.promotionHandlers.values()) {
                        handler.invalidateCaches();
                    }
                }
                catch (RepositoryException e1) {
                    this.log.error("Failed to invalidate cache {}", (Object)e);
                }
            }
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getPromotionsMap(SlingHttpServletRequest request) {
        this.lock.readLock().lock();
        try {
            this.validateCaches();
            HashMap<String, String> map = new HashMap<String, String>();
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            for (Promotion promo : this.promotionsCache) {
                try {
                    if (!promo.isValid() || !session.hasPermission(promo.getPath(), "read")) continue;
                    map.put(promo.getPath(), StringUtils.join(promo.getSegments(), (String)","));
                }
                catch (RepositoryException e) {}
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AbstractJcrVoucher getVoucher(SlingHttpServletRequest request, String code) {
        this.lock.readLock().lock();
        try {
            this.validateCaches();
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            List<AbstractJcrVoucher> vouchers = this.vouchersCache.get(code);
            if (vouchers == null) {
                AbstractJcrVoucher abstractJcrVoucher = null;
                return abstractJcrVoucher;
            }
            AbstractJcrVoucher first = null;
            AbstractJcrVoucher firstValid = null;
            for (AbstractJcrVoucher voucher : vouchers) {
                if (voucher == null || !session.hasPermission(voucher.getPath(), "read")) continue;
                if (first == null) {
                    first = voucher;
                }
                if (!voucher.isValid(request)) continue;
                if (firstValid == null) {
                    firstValid = voucher;
                    continue;
                }
                this.log.warn("Multiple vouchers using the code '{0}' are currently valid.", (Object)code);
            }
            AbstractJcrVoucher abstractJcrVoucher = firstValid != null ? firstValid : first;
            return abstractJcrVoucher;
        }
        catch (RepositoryException e) {
            AbstractJcrVoucher abstractJcrVoucher = null;
            return abstractJcrVoucher;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void validateCaches() {
        if (this.cachesDirty) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.cachesDirty) {
                    this.promotionsCache.clear();
                    this.vouchersCache.clear();
                    this.collector(this.adminResolver.getResource(this.promotionRoot));
                    this.cachesDirty = false;
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    private void collector(Resource r) {
        if (r.isResourceType("commerce/components/voucher")) {
            AbstractJcrVoucher v = (AbstractJcrVoucher)r.getParent().adaptTo(Voucher.class);
            List<AbstractJcrVoucher> list = this.vouchersCache.get(v.getCode());
            if (list == null) {
                list = new ArrayList<AbstractJcrVoucher>();
                this.vouchersCache.put(v.getCode(), list);
            }
            list.add(v);
            Collections.sort(list, VoucherPrioritySorter.INSTANCE);
        } else if (r.isResourceType("commerce/components/promotion")) {
            try {
                PromotionImpl p = new PromotionImpl(r.getParent());
                this.promotionsCache.add(p);
            }
            catch (CommerceException e) {
                this.log.error(e.getMessage());
            }
        } else {
            Iterator i = r.listChildren();
            while (i.hasNext()) {
                this.collector((Resource)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromotionHandler getHandler(String promotionType) {
        this.lock.readLock().lock();
        try {
            PromotionHandler promotionHandler = this.promotionHandlers.get(promotionType);
            return promotionHandler;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VoucherPrioritySorter
    implements Comparator<AbstractJcrVoucher> {
        public static final VoucherPrioritySorter INSTANCE = new VoucherPrioritySorter();

        private VoucherPrioritySorter() {
        }

        @Override
        public int compare(AbstractJcrVoucher o1, AbstractJcrVoucher o2) {
            long p2;
            long p1 = o1.getPriority();
            return p1 < (p2 = o2.getPriority()) ? 1 : (p1 != p2 ? -1 : 0);
        }
    }
}

