/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import com.day.cq.commons.Filter;
import com.day.cq.personalization.TargetedContentManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignReferenceProvider
implements ReferenceProvider {
    private static final String RT_ANYMBOX = "cq/personalization/components/anymbox";
    private static final String TYPE_CAMPAIGN = "campaign";
    private final Logger log = LoggerFactory.getLogger(CampaignReferenceProvider.class);
    private TargetedContentManager targetedContentManager;

    public List<Reference> findReferences(Resource resource) {
        final ArrayList<String> anyMboxLocations = new ArrayList<String>();
        this.findAnyMboxLocations(resource, anyMboxLocations);
        this.log.debug("For page at {} found anyMbox locations {}", (Object)resource.getPath(), anyMboxLocations);
        try {
            List campaigns = this.targetedContentManager.getCampaigns(resource.getResourceResolver());
            final HashMap<String, Reference> references = new HashMap<String, Reference>();
            for (Page campaign : campaigns) {
                Iterator matchingTeaserPages = campaign.listChildren((Filter)new Filter<Page>(){

                    public boolean includes(Page page) {
                        return "cq/personalization/components/teaserpage".equals(page.getContentResource().getResourceType()) && anyMboxLocations.contains(((ValueMap)page.getContentResource().adaptTo(ValueMap.class)).get("location", null)) && !references.containsKey(page.getParent(2).getPath());
                    }
                }, true);
                if (!matchingTeaserPages.hasNext()) continue;
                long lastModified = this.computeLastModified(campaign);
                while (matchingTeaserPages.hasNext()) {
                    Page teaserPage = (Page)matchingTeaserPages.next();
                    Page campaignPage = teaserPage.getParent(2);
                    references.put(campaignPage.getPath(), new Reference(TYPE_CAMPAIGN, campaignPage.getName(), (Resource)campaignPage.adaptTo(Resource.class), lastModified));
                    this.log.debug("For page at {} adding reference to campaign at {}", (Object)resource.getPath(), (Object)campaignPage.getPath());
                }
            }
            return new ArrayList<Reference>(references.values());
        }
        catch (RepositoryException e) {
            this.log.warn("Unable to find campaign references for resource at " + resource.getPath(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private long computeLastModified(Page campaign) {
        long lastModified = this.lastModifiedInMillis(campaign);
        Iterator children = campaign.listChildren((Filter)new Filter<Page>(){

            public boolean includes(Page page) {
                String resourceType = page.getContentResource().getResourceType();
                return "cq/personalization/components/experiencepage".equals(resourceType) || "cq/personalization/components/teaserpage".equals(resourceType);
            }
        }, true);
        while (children.hasNext()) {
            lastModified = Math.max(lastModified, this.lastModifiedInMillis((Page)children.next()));
        }
        return lastModified;
    }

    private long lastModifiedInMillis(Page matchingTeaserPage) {
        return matchingTeaserPage.getLastModified() != null ? matchingTeaserPage.getLastModified().getTimeInMillis() : -1L;
    }

    private void findAnyMboxLocations(Resource resource, List<String> locations) {
        Iterator children = resource.listChildren();
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            if (child.getResourceType().equals(RT_ANYMBOX)) {
                this.log.debug("Found anymbox at {}", (Object)child.getPath());
                locations.add(child.getPath());
                continue;
            }
            this.findAnyMboxLocations(child, locations);
        }
    }

    protected void bindTargetedContentManager(TargetedContentManager targetedContentManager) {
        this.targetedContentManager = targetedContentManager;
    }

    protected void unbindTargetedContentManager(TargetedContentManager targetedContentManager) {
        if (this.targetedContentManager == targetedContentManager) {
            this.targetedContentManager = null;
        }
    }
}

