/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.personalization.ContextSessionPersistence;
import com.day.cq.personalization.ProfileProvider;
import com.day.cq.personalization.UserPropertiesProvider;
import com.day.cq.security.profile.Profile;
import com.day.cq.security.profile.ProfileManager;
import com.day.cq.wcm.api.WCMMode;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextProfileProvider
implements ProfileProvider,
UserPropertiesProvider {
    private final Logger log = LoggerFactory.getLogger(ContextProfileProvider.class);
    private SlingRepository repository = null;
    private ProfileManager profileManager = null;

    public Profile getProfile(SlingHttpServletRequest request) {
        return this.getProfileOrUserProperties(request, Profile.class);
    }

    public Profile getProfile(ResourceResolver resolver) {
        return null;
    }

    public UserProperties getUserProperties(SlingHttpServletRequest request) {
        return this.getProfileOrUserProperties(request, UserProperties.class);
    }

    public UserProperties getUserProperties(ResourceResolver resolver) {
        return null;
    }

    private <T> T getProfileOrUserProperties(SlingHttpServletRequest request, Class<T> clazz) {
        if (WCMMode.DISABLED != WCMMode.fromRequest((ServletRequest)request)) {
            T t;
            String authorizableId;
            Map contextProfile = ContextSessionPersistence.getStore((SlingHttpServletRequest)request, (String)"PROFILEDATA");
            if (contextProfile.containsKey("authorizableId")) {
                authorizableId = (String)contextProfile.get("authorizableId");
                try {
                    t = this.getProfileObject(authorizableId, request.getResourceResolver(), clazz);
                    if (t != null) {
                        return t;
                    }
                }
                catch (RepositoryException e) {
                    this.log.error("error while getting {}: ", (Object)clazz.getSimpleName(), (Object)e);
                }
            }
            if ((contextProfile = ContextSessionPersistence.getStore((SlingHttpServletRequest)request, (String)"CLICKSTREAMCLOUD")).containsKey("visitorId")) {
                authorizableId = (String)contextProfile.get("visitorId");
                try {
                    t = this.getProfileObject(authorizableId, request.getResourceResolver(), clazz);
                    if (t != null) {
                        return t;
                    }
                }
                catch (RepositoryException e) {
                    this.log.error("error while getting {}: ", (Object)clazz.getSimpleName(), (Object)e);
                }
            }
            try {
                T t2 = this.getProfileObject("anonymous", request.getResourceResolver(), clazz);
                if (t2 != null) {
                    return t2;
                }
            }
            catch (RepositoryException e) {
                this.log.error("error while getting {}: ", (Object)clazz.getSimpleName(), (Object)e);
            }
        }
        return null;
    }

    private <T> T getProfileObject(String authorizableId, ResourceResolver resolver, Class<T> clazz) throws RepositoryException {
        if (clazz == Profile.class) {
            return (T)this.profileManager.getProfile(authorizableId, (Session)resolver.adaptTo(Session.class));
        }
        if (clazz == UserProperties.class) {
            UserPropertiesManager upm = (UserPropertiesManager)resolver.adaptTo(UserPropertiesManager.class);
            if (null != upm) {
                return (T)upm.getUserProperties(authorizableId, "profile");
            }
            this.log.error("getProfileOrUserProperties: UserPropertiesManager unavailable");
        }
        return null;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    protected void unbindProfileManager(ProfileManager profileManager) {
        if (this.profileManager == profileManager) {
            this.profileManager = null;
        }
    }
}

