/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MboxifyServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(MboxifyServlet.class);
    public static final String MBOX_COMPONENT = "cq/personalization/components/anymbox";
    public static final String DEFAULT_NODE = "default";
    public static final String REVERT_SELECTOR = "revert";

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.log.debug("mboxify servlet called");
        boolean revert = MboxifyServlet.hasSelector(request.getRequestPathInfo(), REVERT_SELECTOR);
        boolean success = true;
        try {
            if (revert) {
                this.revertMboxify((Node)request.getResource().adaptTo(Node.class));
            } else {
                this.mboxify((Node)request.getResource().adaptTo(Node.class));
            }
        }
        catch (RepositoryException e) {
            this.log.error("Cannot " + (revert ? "revert mboxification" : "mboxify") + " '" + request.getResource().getPath() + "'", (Throwable)e);
            success = false;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        JSONWriter writer = new JSONWriter((Writer)out);
        try {
            writer.object();
            writer.key("success").value(success);
            writer.endObject();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void mboxify(Node component) throws RepositoryException {
        String name = component.getName();
        Node parent = component.getParent();
        Session session = component.getSession();
        String nodeAfter = MboxifyServlet.getNodeAfter(component);
        String tmpNodePath = MboxifyServlet.moveToTempNode(component, parent);
        Node newNode = parent.addNode(name);
        newNode.setProperty("sling:resourceType", MBOX_COMPONENT);
        parent.orderBefore(name, nodeAfter);
        session.move(tmpNodePath, newNode.getPath() + "/" + DEFAULT_NODE);
        session.save();
    }

    private void revertMboxify(Node component) throws RepositoryException {
        if (!component.hasNode(DEFAULT_NODE) && !(component = component.getParent()).hasNode(DEFAULT_NODE)) {
            return;
        }
        String name = component.getName();
        Node wrappedComponent = component.getNode(DEFAULT_NODE);
        Node parent = component.getParent();
        Session session = component.getSession();
        String nodeAfter = MboxifyServlet.getNodeAfter(component);
        String tmpNodePath = MboxifyServlet.moveToTempNode(wrappedComponent, parent);
        String path = component.getPath();
        component.remove();
        session.move(tmpNodePath, path);
        parent.orderBefore(name, nodeAfter);
        session.save();
    }

    public static String getNodeAfter(Node node) throws RepositoryException {
        NodeIterator nodes = node.getParent().getNodes();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            if (!n.isSame((Item)node)) continue;
            if (nodes.hasNext()) {
                return nodes.nextNode().getName();
            }
            return null;
        }
        throw new RepositoryException("Could not find node in getParent().getNodes(): " + node.getPath());
    }

    public static String moveToTempNode(Node node, Node parent) throws RepositoryException {
        String tmpName = node.getName() + "_tmp_" + System.currentTimeMillis();
        String tmpNodePath = parent.getPath() + "/" + tmpName;
        node.getSession().move(node.getPath(), tmpNodePath);
        return tmpNodePath;
    }

    public static boolean hasSelector(RequestPathInfo pathInfo, String selector) {
        for (String s : pathInfo.getSelectors()) {
            if (!s.equals(selector)) continue;
            return true;
        }
        return false;
    }
}

