/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import com.day.cq.personalization.Segment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentAdapterFactory
implements AdapterFactory {
    static final String[] ADAPTABLE_CLASSES = new String[]{Resource.class.getName()};
    static final String[] ADAPTER_CLASSES = new String[]{Segment.class.getName()};
    private static final String RT_LOGIC_AND = "cq/personalization/components/traits/logic/and";
    private static final String RT_LOGIC_OR = "cq/personalization/components/traits/logic/or";
    private static final String RT_REFERENCE = "cq/personalization/components/traits/reference";
    private static final String PROFILE_PREFIX = "profile/";
    private static final String PROFILE_UNSUPPORTED = "unsupported";
    private static final Map<String, String> RESOURCE_TYPES_TO_PROPERTY_NAMES;
    private static final Logger log;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        try {
            if (adaptable instanceof Resource && type == Segment.class) {
                Segment adapted = this.adaptNodeToSegment((Node)((Resource)adaptable).adaptTo(Node.class));
                return (AdapterType)adapted;
            }
        }
        catch (RepositoryException e) {
            log.warn("Unable to adapt " + adaptable + " to a " + type.getName(), (Throwable)e);
        }
        return null;
    }

    private Segment adaptNodeToSegment(Node node) throws PathNotFoundException, RepositoryException {
        if (node == null) {
            return null;
        }
        Node traits = node.getNode("jcr:content/traits");
        String traitResourceType = traits.getProperty("sling:resourceType").getString();
        if (!traitResourceType.equals(RT_LOGIC_AND)) {
            log.warn("Unable to handle root segment at {} of type {}", (Object)node.getPath(), (Object)traitResourceType);
            return null;
        }
        Segment rootSegment = Segment.newLogicSegment((Segment.Kind)Segment.Kind.And);
        this.processChildren(rootSegment, traits.getNode("andpar").getNodes());
        return rootSegment;
    }

    private void processChildren(Segment rootSegment, NodeIterator children) throws RepositoryException {
        while (children.hasNext()) {
            String operator;
            Node child = children.nextNode();
            String resourceType = child.getProperty("sling:resourceType").getString();
            if (resourceType.equals(RT_LOGIC_AND)) {
                Segment and = Segment.newLogicSegment((Segment.Kind)Segment.Kind.And);
                rootSegment.addChild(and);
                this.processChildren(and, child.getNode("andpar").getNodes());
                continue;
            }
            if (resourceType.equals(RT_LOGIC_OR)) {
                Segment or = Segment.newLogicSegment((Segment.Kind)Segment.Kind.Or);
                rootSegment.addChild(or);
                this.processChildren(or, child.getNode("orpar").getNodes());
                continue;
            }
            if (RT_REFERENCE.equals(resourceType)) {
                String segmentPath = child.getProperty("segmentPath").getString();
                child = child.getSession().getNode(segmentPath);
                Node traits = child.getNode("jcr:content/traits");
                this.processChildren(rootSegment, traits.getNode("andpar").getNodes());
                continue;
            }
            String name = RESOURCE_TYPES_TO_PROPERTY_NAMES.get(resourceType);
            if (name == null) {
                log.warn("Unknown resource type {} at path {} ; skipping.", (Object)resourceType, (Object)child.getPath());
                continue;
            }
            if (PROFILE_UNSUPPORTED.equals(name)) {
                log.debug("Skippping unsupported segment type {} at path {}", (Object)resourceType, (Object)child.getPath());
                continue;
            }
            if (PROFILE_PREFIX.equals(name)) {
                name = name + child.getProperty("name").getString();
            }
            Property valueProperty = child.getProperty("value");
            String string = operator = child.hasProperty("operator") ? child.getProperty("operator").getString() : null;
            if (valueProperty.isMultiple()) {
                ArrayList<String> values = new ArrayList<String>(valueProperty.getValues().length);
                for (Value value : valueProperty.getValues()) {
                    values.add(value.getString());
                }
                rootSegment.addChild(Segment.newDirectSegment((String)name, (String)operator, values));
                continue;
            }
            rootSegment.addChild(Segment.newDirectSegment((String)name, (String)operator, (String)valueProperty.getString()));
        }
    }

    static {
        HashMap<String, String> resourceTypesToPropertyNames = new HashMap<String, String>();
        resourceTypesToPropertyNames.put("cq/personalization/components/traits/profileproperty/generic", PROFILE_PREFIX);
        resourceTypesToPropertyNames.put("cq/personalization/components/traits/profileproperty/age", "profile/age");
        resourceTypesToPropertyNames.put("cq/personalization/components/traits/surferinfo/keywords", "profile/keywords");
        resourceTypesToPropertyNames.put("cq/personalization/components/traits/percentile", "percentile");
        resourceTypesToPropertyNames.put("cq/personalization/components/traits/script", PROFILE_UNSUPPORTED);
        RESOURCE_TYPES_TO_PROPERTY_NAMES = Collections.unmodifiableMap(resourceTypesToPropertyNames);
        log = LoggerFactory.getLogger(SegmentAdapterFactory.class);
    }
}

