/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import com.day.cq.commons.Filter;
import com.day.cq.personalization.TargetedContentManager;
import com.day.cq.personalization.TeaserUtils;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetedContentManagerImpl
implements TargetedContentManager,
EventListener {
    private final Logger log = LoggerFactory.getLogger(TargetedContentManagerImpl.class);
    static final String TEASER_TYPE = "cq/personalization/components/teaserpage";
    static final String EXPERIENCE_TYPE = "cq/personalization/components/experiencepage";
    static final String CAMPAIGN_TYPE = "cq/personalization/components/campaignpage";
    static final String DEFAULT_CAMPAIGN_ROOT = "/content/campaigns";
    private static final String CAMPAIGN_ROOT = "cq.mcm.campaign.root";
    private ResourceResolverFactory resolverFactory = null;
    private String promotionRoot;
    private ResourceResolver adminResolver;
    private ObservationManager observationManager;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<String> campaignPathsCache = new ArrayList<String>();
    private boolean cacheDirty = true;

    protected void activate(ComponentContext context) throws Exception {
        this.promotionRoot = OsgiUtil.toString(context.getProperties().get(CAMPAIGN_ROOT), (String)DEFAULT_CAMPAIGN_ROOT);
        this.adminResolver = this.resolverFactory.getAdministrativeResourceResolver(Collections.emptyMap());
        Session adminSession = (Session)this.adminResolver.adaptTo(Session.class);
        this.observationManager = adminSession.getWorkspace().getObservationManager();
        this.observationManager.addEventListener((EventListener)this, 63, "/", true, null, null, true);
    }

    protected void deactivate(ComponentContext context) throws RepositoryException {
        if (this.adminResolver != null && this.adminResolver.isLive()) {
            if (this.observationManager != null) {
                this.observationManager.removeEventListener((EventListener)this);
            }
            this.adminResolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onEvent(EventIterator events) {
        this.lock.writeLock().lock();
        try {
            while (events.hasNext()) {
                Event e = events.nextEvent();
                try {
                    String path = e.getPath();
                    if (!path.startsWith(this.promotionRoot)) continue;
                    this.cacheDirty = true;
                    return;
                }
                catch (RepositoryException e1) {
                    this.log.error("Failed to invalidate cache {}", (Object)e);
                }
            }
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getTeaserInfo(ResourceResolver resolver, String campaignPath, String target) {
        this.lock.readLock().lock();
        try {
            this.validateCache();
            String defaultTeaser = null;
            JSONObject json = new JSONObject();
            JSONArray allTeasers = new JSONArray();
            for (String cachedCampaignPath : this.campaignPathsCache) {
                String[] segments;
                String title;
                Page campaign = this.getPage(resolver, cachedCampaignPath);
                if (campaign == null || !campaign.isValid()) continue;
                String campaignDefaultTeaser = null;
                String campaignName = campaign.getName();
                if (target != null) {
                    Iterator experiences = campaign.listChildren((Filter)new ResourceTypeFilter(EXPERIENCE_TYPE));
                    while (experiences.hasNext()) {
                        Page experience = (Page)experiences.next();
                        title = experience.getTitle();
                        segments = (String[])experience.getProperties().get("cq:segments", (Object)new String[0]);
                        Iterator teasers = experience.listChildren((Filter)new ResourceTypeFilter(TEASER_TYPE));
                        while (teasers.hasNext()) {
                            Page teaser = (Page)teasers.next();
                            if (!((String)teaser.getProperties().get("target", (Object)"")).equals(target)) continue;
                            if (segments.length == 0 && teaser.getTags().length == 0) {
                                campaignDefaultTeaser = teaser.getPath();
                            }
                            allTeasers.put((Object)this.getTeaserInfo(campaignName, title, segments, teaser));
                        }
                    }
                }
                if (campaign.getPath().equals(campaignPath)) {
                    Iterator teasers = campaign.listChildren((Filter)new ResourceTypeFilter(TEASER_TYPE));
                    while (teasers.hasNext()) {
                        Page teaser = (Page)teasers.next();
                        if (!teaser.isValid()) continue;
                        title = teaser.getTitle();
                        segments = (String[])teaser.getProperties().get("cq:segments", (Object)new String[0]);
                        if (segments.length == 0 && teaser.getTags().length == 0) {
                            campaignDefaultTeaser = teaser.getPath();
                        }
                        allTeasers.put((Object)this.getTeaserInfo(campaignName, title, segments, teaser));
                    }
                }
                if (defaultTeaser != null || campaignDefaultTeaser == null) continue;
                defaultTeaser = campaignDefaultTeaser;
            }
            json.put("allTeasers", (Object)allTeasers);
            json.put("defaultTeaserPath", defaultTeaser);
            JSONObject jSONObject = json;
            return jSONObject;
        }
        catch (JSONException e) {
            this.log.error("Failed to generate teaser info", (Throwable)e);
            JSONObject jSONObject = new JSONObject();
            return jSONObject;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Page> getCampaigns(ResourceResolver resourceResolver) throws RepositoryException {
        ArrayList<Page> campaigns = new ArrayList<Page>();
        this.lock.readLock().lock();
        try {
            this.validateCache();
            for (String campaignPath : this.campaignPathsCache) {
                Page campaignPage = this.getPage(resourceResolver, campaignPath);
                if (campaignPage == null) continue;
                campaigns.add(campaignPage);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        Collections.sort(campaigns, CampaignPrioritySorter.INSTANCE);
        return campaigns;
    }

    private Page getPage(ResourceResolver resourceResolver, String campaignPath) {
        Resource resource = resourceResolver.getResource(campaignPath);
        if (resource == null) {
            return null;
        }
        return (Page)resource.adaptTo(Page.class);
    }

    private JSONObject getTeaserInfo(String campaignName, String title, String[] segments, Page teaser) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("path", (Object)teaser.getPath());
        json.put("name", (Object)teaser.getName());
        json.put("title", (Object)title);
        json.put("campainName", (Object)campaignName);
        json.put("thumbnail", (Object)TeaserUtils.getImage((Page)teaser));
        json.put("id", (Object)(campaignName + "_" + teaser.getName()));
        JSONArray segmentsArray = new JSONArray();
        for (String s : segments) {
            segmentsArray.put((Object)s);
        }
        json.put("segments", (Object)segmentsArray);
        JSONArray tagsArray = new JSONArray();
        for (Tag tag : teaser.getTags()) {
            JSONObject tagJson = new JSONObject();
            tagJson.put("name", (Object)tag.getName());
            tagJson.put("title", (Object)tag.getTitle());
            tagJson.put("titlePath", (Object)tag.getTitlePath());
            tagJson.put("path", (Object)tag.getPath());
            tagJson.put("tagID", (Object)tag.getTagID());
            tagsArray.put((Object)tagJson);
        }
        json.put("tags", (Object)tagsArray);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCache() {
        if (this.cacheDirty) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                if (this.cacheDirty) {
                    this.campaignPathsCache.clear();
                    this.collector(this.adminResolver.getResource(this.promotionRoot));
                    this.cacheDirty = false;
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    private void collector(Resource r) {
        if (r.isResourceType(CAMPAIGN_TYPE)) {
            try {
                Page c = (Page)r.getParent().adaptTo(Page.class);
                this.campaignPathsCache.add(c.getPath());
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        } else {
            Iterator i = r.listChildren();
            while (i.hasNext()) {
                this.collector((Resource)i.next());
            }
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceTypeFilter
    implements Filter<Page> {
        private final String type;

        ResourceTypeFilter(String type) {
            this.type = type;
        }

        public boolean includes(Page page) {
            if (page == null) {
                return false;
            }
            Resource r = page.getContentResource();
            return r != null && ResourceUtil.isA((Resource)r, (String)this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CampaignPrioritySorter
    implements Comparator<Page> {
        public static final CampaignPrioritySorter INSTANCE = new CampaignPrioritySorter();

        private CampaignPrioritySorter() {
        }

        @Override
        public int compare(Page o1, Page o2) {
            int p2;
            int p1 = (Integer)ResourceUtil.getValueMap((Resource)o1.getContentResource()).get("priority", (Object)100);
            return p1 < (p2 = ((Integer)ResourceUtil.getValueMap((Resource)o2.getContentResource()).get("priority", (Object)100)).intValue()) ? 1 : (p1 != p2 ? -1 : 0);
        }
    }
}

