/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.component.datasources;

import com.adobe.aem.modernize.component.ComponentRewriteRuleService;
import com.adobe.aem.modernize.impl.RewriteUtils;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.commons.Externalizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.servlet.ServletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"cq/modernize/component/datasource"}, methods={"GET"})
public final class ComponentsDataSource
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ComponentsDataSource.class);
    private static final String CRX_LITE_PATH = "/crx/de/index";
    @Reference
    private ExpressionResolver expressionResolver;
    @Reference
    private Externalizer externalizer;
    @Reference
    private ComponentRewriteRuleService componentRewriteRuleService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Resource resource = request.getResource();
            ValueMap properties = resource.getValueMap();
            String itemResourceType = (String)properties.get("itemResourceType", String.class);
            String path = (String)properties.get("path", String.class);
            path = (String)this.expressionResolver.resolve(path, request.getLocale(), String.class, request);
            if (StringUtils.isEmpty((CharSequence)path)) {
                log.warn("Path unavailable");
                return;
            }
            if (CollectionUtils.isEmpty(this.componentRewriteRuleService.getSlingResourceTypes(request.getResourceResolver()))) {
                return;
            }
            this.setDataSource(path, request, itemResourceType);
        }
        catch (RepositoryException e) {
            log.warn("Unable to list components: {}", (Object)e.getMessage());
        }
    }

    private void setDataSource(String path, SlingHttpServletRequest request, String itemResourceType) throws RepositoryException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (StringUtils.isNotBlank((CharSequence)path)) {
            ResourceResolver resourceResolver = request.getResourceResolver();
            TreeMap<String, Node> nodeMap = new TreeMap<String, Node>();
            if (!(path = path.trim()).startsWith("/")) {
                path = "/" + path;
            }
            this.buildNodeMap(path, nodeMap, resourceResolver);
            this.buildResources(resources, nodeMap, request, itemResourceType);
        }
        SimpleDataSource ds = new SimpleDataSource(resources.iterator());
        request.setAttribute(DataSource.class.getName(), (Object)ds);
    }

    private void buildNodeMap(String searchPath, Map<String, Node> nodeMap, ResourceResolver resolver) throws RepositoryException {
        Resource rootResource = resolver.getResource(searchPath);
        if (rootResource == null) {
            return;
        }
        String slingResourceType = (String)rootResource.getValueMap().get("sling:resourceType", String.class);
        if (this.componentRewriteRuleService.getSlingResourceTypes(resolver).contains(slingResourceType)) {
            nodeMap.put(searchPath, (Node)rootResource.adaptTo(Node.class));
        }
        if (nodeMap.isEmpty()) {
            Query query = this.createQuery(searchPath, resolver);
            NodeIterator iterator = query.execute().getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                nodeMap.put(node.getPath(), node);
            }
        }
    }

    private void buildResources(List<Resource> resources, Map<String, Node> nodes, SlingHttpServletRequest request, String itemResourceType) throws RepositoryException {
        int index = 0;
        for (Map.Entry<String, Node> entry : nodes.entrySet()) {
            Node parent;
            Node component = entry.getValue();
            if (component == null || (parent = component.getParent()) == null) continue;
            String resourceType = component.getProperty("sling:resourceType").getString();
            String componentPath = component.getPath();
            String href = this.externalizer.relativeLink(request, componentPath) + ".html";
            String crxHref = this.externalizer.relativeLink(request, CRX_LITE_PATH) + ".jsp#" + componentPath;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("componentPath", componentPath);
            map.put("resourceType", resourceType);
            map.put("href", href);
            map.put("crxHref", crxHref);
            resources.add((Resource)new ValueMapResource(request.getResourceResolver(), request.getResource() + "/component_" + index, itemResourceType, (ValueMap)new ValueMapDecorator(map)));
            ++index;
        }
    }

    private Query createQuery(String path, ResourceResolver resourceResolver) throws RepositoryException {
        String encodedPath = RewriteUtils.encodePath(path);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM [").append("nt:unstructured").append("] AS res ");
        sb.append("WHERE ISDESCENDANTNODE(res, '").append(encodedPath).append("') ");
        sb.append("AND res.[sling:resourceType] IN (");
        Iterator<String> it = this.componentRewriteRuleService.getSlingResourceTypes(resourceResolver).iterator();
        while (it.hasNext()) {
            sb.append("'").append(it.next()).append("'");
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return queryManager.createQuery(sb.toString(), "JCR-SQL2");
    }

    protected void bindExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    protected void unbindExpressionResolver(ExpressionResolver expressionResolver) {
        if (this.expressionResolver == expressionResolver) {
            this.expressionResolver = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindComponentRewriteRuleService(ComponentRewriteRuleService componentRewriteRuleService) {
        this.componentRewriteRuleService = componentRewriteRuleService;
    }

    protected void unbindComponentRewriteRuleService(ComponentRewriteRuleService componentRewriteRuleService) {
        if (this.componentRewriteRuleService == componentRewriteRuleService) {
            this.componentRewriteRuleService = null;
        }
    }
}

