/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.component.impl;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.component.ComponentRewriteRule;
import com.adobe.aem.modernize.component.ComponentRewriteRuleService;
import com.adobe.aem.modernize.component.impl.ComponentTreeRewriter;
import java.io.IOException;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, paths={"/libs/cq/modernize/component/content/convert"}, extensions={"json"})
public class ComponentConversionServlet
extends SlingAllMethodsServlet {
    public static final String PARAM_PATHS = "paths";
    private static final String KEY_RESULT_PATH = "resultPath";
    private static final String KEY_ERROR_MESSAGE = "errorMessage";
    private Logger logger = LoggerFactory.getLogger(ComponentConversionServlet.class);
    @Reference
    ComponentRewriteRuleService componentRewriteRuleService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameter[] paths = request.getRequestParameters(PARAM_PATHS);
        if (paths == null) {
            this.logger.warn("Missing parameter 'paths'");
            response.setContentType("text/html");
            response.getWriter().println("Missing parameter 'paths'");
            response.setStatus(400);
            return;
        }
        try {
            List<ComponentRewriteRule> rules = this.componentRewriteRuleService.getRules(request.getResourceResolver());
            long tick = System.currentTimeMillis();
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            ComponentTreeRewriter rewriter = new ComponentTreeRewriter(rules);
            JSONObject results = new JSONObject();
            this.logger.debug("Converting {} components", (Object)paths.length);
            for (RequestParameter parameter : paths) {
                String path = parameter.getString();
                JSONObject json = new JSONObject();
                results.put(path, (Object)json);
                if (!session.nodeExists(path)) {
                    json.put(KEY_ERROR_MESSAGE, (Object)"Invalid path");
                    this.logger.debug("Path {} doesn't exist", (Object)path);
                    continue;
                }
                try {
                    Node result = rewriter.rewrite(session.getNode(path));
                    json.put(KEY_RESULT_PATH, (Object)result.getPath());
                    this.logger.debug("Successfully converted component {} to {}", (Object)path, (Object)result.getPath());
                }
                catch (RewriteException e) {
                    json.put(KEY_ERROR_MESSAGE, (Object)e.getMessage());
                    this.logger.warn("Converting component {} failed", (Object)path, (Object)e);
                }
            }
            response.setContentType("application/json");
            response.getWriter().write(results.toString());
            long tack = System.currentTimeMillis();
            this.logger.debug("Rewrote {} components in {} ms", (Object)paths.length, (Object)(tack - tick));
        }
        catch (Exception e) {
            throw new ServletException("Caught exception while rewriting components", (Throwable)e);
        }
    }

    protected void bindComponentRewriteRuleService(ComponentRewriteRuleService componentRewriteRuleService) {
        this.componentRewriteRuleService = componentRewriteRuleService;
    }

    protected void unbindComponentRewriteRuleService(ComponentRewriteRuleService componentRewriteRuleService) {
        if (this.componentRewriteRuleService == componentRewriteRuleService) {
            this.componentRewriteRuleService = null;
        }
    }
}

