/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.component.impl;

import com.adobe.aem.modernize.component.ComponentRewriteRule;
import com.adobe.aem.modernize.component.ComponentRewriteRuleService;
import com.adobe.aem.modernize.component.impl.rules.NodeBasedComponentRewriteRule;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class ComponentRewriteRuleServiceImpl
implements ComponentRewriteRuleService {
    private Logger logger = LoggerFactory.getLogger(ComponentRewriteRuleServiceImpl.class);
    public static final String RULES_SEARCH_PATH = "cq/modernize/component/rules";
    @Reference(referenceInterface=ComponentRewriteRule.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindRule", unbind="unbindRule")
    private List<ComponentRewriteRule> rules = Collections.synchronizedList(new LinkedList());

    public void bindRule(ComponentRewriteRule rule) {
        this.rules.add(rule);
    }

    public void unbindRule(ComponentRewriteRule rule) {
        this.rules.remove(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentRewriteRule> getRules(ResourceResolver resolver) throws RepositoryException {
        LinkedList<ComponentRewriteRule> rules = new LinkedList<ComponentRewriteRule>();
        List<ComponentRewriteRule> list = this.rules;
        synchronized (list) {
            rules.addAll(this.rules);
        }
        int jb = rules.size();
        Resource resource = resolver.getResource(RULES_SEARCH_PATH);
        if (resource != null) {
            Node rulesContainer = (Node)resource.adaptTo(Node.class);
            NodeIterator iterator = rulesContainer.getNodes();
            while (iterator.hasNext()) {
                Node nextNode = iterator.nextNode();
                if (this.isFolder(nextNode)) {
                    NodeIterator nodeIterator = nextNode.getNodes();
                    while (nodeIterator.hasNext()) {
                        Node nestedNode = nodeIterator.nextNode();
                        if (this.isFolder(nestedNode)) continue;
                        rules.add(new NodeBasedComponentRewriteRule(nestedNode));
                    }
                    continue;
                }
                rules.add(new NodeBasedComponentRewriteRule(nextNode));
            }
        }
        Collections.sort(rules, new RuleComparator());
        this.logger.debug("Found {} rules ({} Java-based, {} node-based)", new Object[]{rules.size(), jb, rules.size() - jb});
        if (this.logger.isDebugEnabled()) {
            for (ComponentRewriteRule rule : rules) {
                this.logger.debug(rule.toString());
            }
        }
        return rules;
    }

    @Override
    public Set<String> getSlingResourceTypes(ResourceResolver resolver) throws RepositoryException {
        List<ComponentRewriteRule> rules = this.getRules(resolver);
        HashSet<String> types = new HashSet<String>(rules.size());
        for (ComponentRewriteRule r : rules) {
            types.addAll(r.getSlingResourceTypes());
        }
        return types;
    }

    private boolean isFolder(Node node) throws RepositoryException {
        String primaryType = node.getPrimaryNodeType().getName();
        return primaryType.equals("sling:Folder") || primaryType.equals("sling:OrderedFolder") || primaryType.equals("nt:folder");
    }

    private class RuleComparator
    implements Comparator<ComponentRewriteRule> {
        private RuleComparator() {
        }

        @Override
        public int compare(ComponentRewriteRule rule1, ComponentRewriteRule rule2) {
            int ranking1 = rule1.getRanking();
            int ranking2 = rule2.getRanking();
            return Double.compare(ranking1, ranking2);
        }
    }
}

