/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.component.impl;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.component.ComponentRewriteRule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTreeRewriter {
    private Logger logger = LoggerFactory.getLogger(ComponentTreeRewriter.class);
    private List<ComponentRewriteRule> rules;

    public ComponentTreeRewriter(List<ComponentRewriteRule> rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node rewrite(Node root) throws RewriteException, RepositoryException {
        String rootPath = root.getPath();
        this.logger.debug("Rewriting component's content tree rooted at {}", (Object)rootPath);
        long tick = System.currentTimeMillis();
        Session session = root.getSession();
        boolean success = false;
        Node startNode = root;
        try {
            Node parent = root.getParent();
            boolean ordered = parent.getPrimaryNodeType().hasOrderableChildNodes();
            NodeIterator siblings = parent.getNodes();
            while (siblings.hasNext()) {
                Node node = siblings.nextNode();
                if (startNode.getPath().equals(node.getPath())) {
                    for (ComponentRewriteRule rule : this.rules) {
                        if (!rule.matches(node)) continue;
                        this.logger.debug("Rule {} matched subtree rooted at {}", (Object)rule, (Object)node.getPath());
                        startNode = node = rule.applyTo(node, new HashSet<Node>());
                        break;
                    }
                }
                if (!ordered) continue;
                parent.orderBefore(node.getName(), null);
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    session.refresh(false);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Could not revert changes", (Throwable)e);
                }
            }
        }
        session.save();
        long tack = System.currentTimeMillis();
        this.logger.debug("Rewrote component tree rooted at {} in {} ms", (Object)rootPath, (Object)(tack - tick));
        return startNode;
    }

    private void addPaths(Set<String> paths, Set<Node> nodes) throws RepositoryException {
        for (Node node : nodes) {
            paths.add(node.getPath());
        }
    }
}

