/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.design.datasources;

import com.adobe.aem.modernize.design.PoliciesImportRuleService;
import com.adobe.aem.modernize.design.impl.PoliciesImportUtils;
import com.adobe.aem.modernize.impl.RewriteUtils;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"cq/modernize/design/componentstyles/datasource"}, methods={"GET"})
public final class ComponentStylesDataSource
extends SlingSafeMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentStylesDataSource.class);
    private static final String CRX_LITE_PATH = "/crx/de/index";
    @Reference
    private ExpressionResolver expressionResolver;
    @Reference
    private Externalizer externalizer;
    @Reference
    private PoliciesImportRuleService policiesImportRuleService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        ValueMap properties = resource.getValueMap();
        String designPath = (String)properties.get("designPath", String.class);
        if (StringUtils.isEmpty((CharSequence)(designPath = PoliciesImportUtils.getDesignPath((String)this.expressionResolver.resolve(designPath, request.getLocale(), String.class, request))))) {
            LOGGER.warn("Path unavailable");
            return;
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        ResourceResolver resolver = request.getResourceResolver();
        Designer designer = (Designer)resolver.adaptTo(Designer.class);
        Design design = designer.getDesign(designPath);
        if (design == null) {
            LOGGER.warn("Design does not exist: {}", (Object)designPath);
            return;
        }
        if (!design.hasContent()) {
            LOGGER.warn("Design at {} is empty", (Object)designPath);
            return;
        }
        try {
            if (CollectionUtils.isEmpty(this.policiesImportRuleService.getSlingResourceTypes(resolver))) {
                return;
            }
            String designContentResourcePath = design.getContentResource().getPath();
            Iterator it = resolver.findResources(this.generateQuery(designContentResourcePath, resolver), "JCR-SQL2");
            int index = 0;
            while (it.hasNext()) {
                result.add(this.buildResource((Resource)it.next(), request, designContentResourcePath, (String)properties.get("itemResourceType", String.class), index++));
            }
            SimpleDataSource ds = new SimpleDataSource(result.iterator());
            request.setAttribute(DataSource.class.getName(), (Object)ds);
        }
        catch (RepositoryException ex) {
            LOGGER.warn("Unable to list Component designs: {}", (Object)ex.getMessage());
        }
    }

    private String generateQuery(String rootPath, ResourceResolver resourceResolver) throws RepositoryException {
        String path = RewriteUtils.encodePath(rootPath);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM [").append("nt:unstructured").append("] AS design ");
        sb.append("WHERE ISDESCENDANTNODE(design, '").append(path).append("') ");
        sb.append("AND design.[sling:resourceType] IN ( ");
        Iterator<String> it = this.policiesImportRuleService.getSlingResourceTypes(resourceResolver).iterator();
        while (it.hasNext()) {
            sb.append("'").append(it.next()).append("'");
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private Resource buildResource(Resource resource, SlingHttpServletRequest request, String rootPath, String itemResourceType, int index) {
        ValueMap props = resource.getValueMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String resourceType = (String)props.get("sling:resourceType", String.class);
        map.put("resourceType", resourceType);
        String cellPath = resource.getPath().replaceFirst(rootPath + "/", "");
        map.put("cellPath", cellPath);
        String crxHref = this.externalizer.relativeLink(request, CRX_LITE_PATH) + ".jsp#" + RewriteUtils.encodePath(resource.getPath());
        map.put("crxHref", crxHref);
        String policyPath = (String)props.get("cq:imported", String.class);
        map.put("imported", policyPath != null);
        if (policyPath != null) {
            map.put("policyHref", this.externalizer.relativeLink(request, CRX_LITE_PATH) + ".jsp#" + RewriteUtils.encodePath(policyPath));
        }
        return new ValueMapResource(request.getResourceResolver(), request.getResource() + "/component_" + index, itemResourceType, (ValueMap)new ValueMapDecorator(map));
    }

    protected void bindExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    protected void unbindExpressionResolver(ExpressionResolver expressionResolver) {
        if (this.expressionResolver == expressionResolver) {
            this.expressionResolver = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindPoliciesImportRuleService(PoliciesImportRuleService policiesImportRuleService) {
        this.policiesImportRuleService = policiesImportRuleService;
    }

    protected void unbindPoliciesImportRuleService(PoliciesImportRuleService policiesImportRuleService) {
        if (this.policiesImportRuleService == policiesImportRuleService) {
            this.policiesImportRuleService = null;
        }
    }
}

