/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.design.impl;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.design.PoliciesImportRule;
import com.adobe.aem.modernize.design.PoliciesImportRuleService;
import com.adobe.aem.modernize.design.impl.PoliciesImportUtils;
import com.adobe.aem.modernize.design.impl.PoliciesTreeImporter;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.text.Text;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, paths={"/libs/cq/modernize/design/content/import"}, extensions={"json"})
public class PoliciesImportServlet
extends SlingAllMethodsServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(PoliciesImportServlet.class);
    public static final String PARAM_PATHS = "paths";
    public static final String PARAM_DESIGN_PATH = "designPath";
    public static final String PARAM_TARGET_PATH = "targetPath";
    private static final String KEY_RESULT_PATH = "resultPath";
    private static final String KEY_ERROR_MESSAGE = "errorMessage";
    @Reference
    PoliciesImportRuleService policiesImportRuleService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameter[] paths = request.getRequestParameters(PARAM_PATHS);
        if (paths == null) {
            this.respondWrongParam(response, PARAM_PATHS);
            return;
        }
        String designPath = request.getParameter(PARAM_DESIGN_PATH);
        if (StringUtils.isEmpty((CharSequence)designPath)) {
            this.respondWrongParam(response, PARAM_DESIGN_PATH);
            return;
        }
        String targetPath = request.getParameter(PARAM_TARGET_PATH);
        if (StringUtils.isEmpty((CharSequence)targetPath)) {
            this.respondWrongParam(response, PARAM_TARGET_PATH);
            return;
        }
        try {
            List<PoliciesImportRule> rules = this.policiesImportRuleService.getRules(request.getResourceResolver());
            long tick = System.currentTimeMillis();
            ResourceResolver resolver = request.getResourceResolver();
            Designer designer = (Designer)resolver.adaptTo(Designer.class);
            Design design = designer.getDesign(PoliciesImportUtils.getDesignPath(designPath));
            PoliciesTreeImporter importer = new PoliciesTreeImporter(rules);
            targetPath = Text.makeCanonicalPath((String)(targetPath + "/settings/wcm/policies"));
            JSONObject results = new JSONObject();
            LOGGER.debug("Importing {} policies; target path: {}", (Object)paths.length, (Object)targetPath);
            for (RequestParameter parameter : paths) {
                String path = parameter.getString();
                JSONObject json = new JSONObject();
                results.put(path, (Object)json);
                Style style = design.getStyle(path);
                if (style == null) {
                    json.put(KEY_ERROR_MESSAGE, (Object)"Invalid style");
                    LOGGER.debug("Style {} doesn't exist at {}", (Object)path, (Object)designPath);
                    continue;
                }
                try {
                    String policyPath = importer.importStyleAsPolicy(resolver, style, targetPath);
                    json.put(KEY_RESULT_PATH, (Object)policyPath);
                    LOGGER.debug("Successfully imported policy {} to {}", (Object)path, (Object)policyPath);
                }
                catch (RewriteException e) {
                    json.put(KEY_ERROR_MESSAGE, (Object)e.getMessage());
                    LOGGER.warn("Importing policy {} failed", (Object)path, (Object)e);
                }
            }
            response.setContentType("application/json");
            response.getWriter().write(results.toString());
            long tack = System.currentTimeMillis();
            LOGGER.debug("Imported {} policies in {} ms", (Object)paths.length, (Object)(tack - tick));
        }
        catch (Exception e) {
            throw new ServletException("Caught exception while importing policies", (Throwable)e);
        }
    }

    private void respondWrongParam(SlingHttpServletResponse response, String param) throws IOException {
        LOGGER.warn("Missing parameter '{}'", (Object)param);
        response.setContentType("text/html");
        response.getWriter().println("Missing parameter '" + param + "'");
        response.setStatus(400);
    }

    protected void bindPoliciesImportRuleService(PoliciesImportRuleService policiesImportRuleService) {
        this.policiesImportRuleService = policiesImportRuleService;
    }

    protected void unbindPoliciesImportRuleService(PoliciesImportRuleService policiesImportRuleService) {
        if (this.policiesImportRuleService == policiesImportRuleService) {
            this.policiesImportRuleService = null;
        }
    }
}

