/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.design.impl;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.design.PoliciesImportRule;
import com.day.cq.wcm.api.designer.Style;
import com.day.text.Text;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PoliciesTreeImporter {
    private static Logger LOGGER = LoggerFactory.getLogger(PoliciesTreeImporter.class);
    private static final String PN_POLICY_RESOURCE_TYPE = "policyResourceType";
    private List<PoliciesImportRule> rules;

    PoliciesTreeImporter(List<PoliciesImportRule> rules) {
        this.rules = rules;
    }

    String importStyleAsPolicy(ResourceResolver resolver, Style style, String targetPath) throws RewriteException, RepositoryException {
        LOGGER.debug("Importing style {} as a policy under {}", (Object)style.getPath(), (Object)targetPath);
        long tick = System.currentTimeMillis();
        Node styleNode = (Node)resolver.getResource(style.getPath()).adaptTo(Node.class);
        PoliciesImportRule matchedRule = null;
        for (PoliciesImportRule policiesImportRule : this.rules) {
            if (!policiesImportRule.matches(styleNode)) continue;
            matchedRule = policiesImportRule;
            break;
        }
        if (matchedRule == null) {
            throw new RewriteException("No matched rule for the specified style definition.");
        }
        String resourceType = matchedRule.getReplacementSlingResourceType();
        if (StringUtils.isEmpty((CharSequence)resourceType)) {
            throw new RewriteException("Unable to get resource type from matched rule: " + matchedRule.toString());
        }
        for (String s : resolver.getSearchPath()) {
            if (!resourceType.startsWith(s)) continue;
            resourceType = resourceType.replaceFirst(s, "");
            break;
        }
        String string = Text.makeCanonicalPath((String)(targetPath + "/" + resourceType));
        try {
            Resource parent = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)string, (String)"nt:unstructured", (String)"nt:unstructured", (boolean)false);
            HashMap properties = new HashMap(style);
            Resource policy = resolver.create(parent, ResourceUtil.createUniqueChildName((Resource)parent, (String)"policy"), properties);
            Node updated = matchedRule.applyTo((Node)policy.adaptTo(Node.class), new HashSet<Node>());
            updated.setProperty("sling:resourceType", "wcm/core/components/policy/policy");
            updated.setProperty(PN_POLICY_RESOURCE_TYPE, resourceType);
            updated.setProperty("jcr:title", "Imported (" + style.getCell().getPath() + ")");
            updated.setProperty("jcr:description", "Imported from " + style.getPath());
            Resource old = resolver.getResource(style.getPath());
            if (old != null) {
                ((ModifiableValueMap)old.adaptTo(ModifiableValueMap.class)).put((Object)"cq:imported", (Object)policy.getPath());
            }
            resolver.commit();
            long tack = System.currentTimeMillis();
            LOGGER.debug("Imported style {} as {} in {} ms", new Object[]{style.getPath(), policy.getPath(), tack - tick});
            return updated.getPath();
        }
        catch (PersistenceException e) {
            resolver.revert();
            throw new RewriteException("Unable to import policy " + style.getPath() + " into " + targetPath, e);
        }
    }
}

