/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.design.impl.rules;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.design.PoliciesImportRule;
import com.adobe.aem.modernize.impl.RewriteUtils;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={PoliciesImportRule.class})
@Component(metatype=true, label="Responsive Grid Policy Import Rule", description="Imports parsys design configurations as responsive grid policies.")
@Properties(value={@Property(name="service.ranking", intValue={1})})
public class ResponsiveGridPolicyImportRule
implements PoliciesImportRule {
    private static final Logger logger = LoggerFactory.getLogger(ResponsiveGridPolicyImportRule.class);
    private static final String PARSYS_RESOURCE_TYPE = "foundation/components/parsys";
    private static Set<String> patternSlingResourceTypes = new HashSet<String>();
    private int ranking = Integer.MAX_VALUE;

    @Override
    public Set<String> getPatternSlingResourceTypes() throws RepositoryException {
        return new HashSet<String>(patternSlingResourceTypes);
    }

    @Override
    public String getReplacementSlingResourceType() throws RepositoryException {
        return "wcm/foundation/components/responsivegrid";
    }

    @Override
    public boolean matches(Node root) throws RepositoryException {
        if (!RewriteUtils.hasPrimaryType(root, "nt:unstructured")) {
            return false;
        }
        if (!root.hasProperty("sling:resourceType")) {
            return false;
        }
        String srt = root.getProperty("sling:resourceType").getString();
        return StringUtils.equals((CharSequence)srt, (CharSequence)PARSYS_RESOURCE_TYPE);
    }

    @Override
    public Node applyTo(Node root, Set<Node> finalNodes) throws RewriteException, RepositoryException {
        root.setProperty("sling:resourceType", "wcm/core/components/policy/policy");
        return root;
    }

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
        Dictionary props = context.getProperties();
        Object ranking = props.get("service.ranking");
        if (ranking != null) {
            try {
                this.ranking = (Integer)ranking;
            }
            catch (ClassCastException e) {
                logger.warn("Found invalid service.ranking value {}", ranking);
            }
        }
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    static {
        patternSlingResourceTypes.add(PARSYS_RESOURCE_TYPE);
        patternSlingResourceTypes = Collections.unmodifiableSet(patternSlingResourceTypes);
    }
}

