/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.dialog;

import com.adobe.aem.modernize.dialog.DialogType;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

public class DialogRewriteUtils {
    public static final String CORAL_2_BACKUP_SUFFIX = ".coral2";
    public static final String NT_DIALOG = "cq:Dialog";
    public static final String NN_CQ_DIALOG = "cq:dialog";
    public static final String NN_CQ_DESIGN_DIALOG = "cq:design_dialog";
    public static final String DIALOG_CONTENT_RESOURCETYPE_PREFIX_CORAL3 = "granite/ui/components/coral/foundation";
    private static final String[] CLASSIC_DIALOG_NAMES = new String[]{"dialog", "design_dialog"};
    private static final String[] DIALOG_NAMES = new String[]{"cq:dialog", "cq:design_dialog", "cq:dialog.coral2", "cq:design_dialog.coral2"};

    public static boolean hasXtype(Node node, String xtype) throws RepositoryException {
        if (xtype == null) {
            return !node.hasProperty("xtype");
        }
        return node.hasProperty("xtype") && xtype.equals(node.getProperty("xtype").getString());
    }

    public static boolean hasType(Node node, String type) throws RepositoryException {
        if (type == null) {
            return !node.hasProperty("type");
        }
        return node.hasProperty("type") && type.equals(node.getProperty("type").getString());
    }

    public static Property copyProperty(Node source, String relPropertyPath, Node destination, String name) throws RepositoryException {
        if (!source.hasProperty(relPropertyPath)) {
            return null;
        }
        return JcrUtil.copy((Property)source.getProperty(relPropertyPath), (Node)destination, (String)name);
    }

    public static DialogType getDialogType(Node node) throws RepositoryException {
        DialogType type = DialogType.UNKNOWN;
        if (node == null) {
            return type;
        }
        String name = node.getName();
        if (Arrays.asList(CLASSIC_DIALOG_NAMES).contains(name) && NT_DIALOG.equals(node.getPrimaryNodeType().getName())) {
            type = DialogType.CLASSIC;
        } else if (Arrays.asList(DIALOG_NAMES).contains(name) && node.hasNode("content")) {
            Node contentNode = node.getNode("content");
            type = DialogType.CORAL_2;
            if (contentNode != null && contentNode.hasProperty("sling:resourceType")) {
                String resourceType = contentNode.getProperty("sling:resourceType").getString();
                type = resourceType.startsWith(DIALOG_CONTENT_RESOURCETYPE_PREFIX_CORAL3) ? DialogType.CORAL_3 : DialogType.CORAL_2;
            }
        }
        return type;
    }

    public static boolean isDesignDialog(Node node) throws RepositoryException {
        if (node == null) {
            return false;
        }
        String name = node.getName();
        return name.equals("design_dialog") || name.equals(NN_CQ_DESIGN_DIALOG) || name.equals("cq:design_dialog.coral2");
    }
}

