/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.dialog.datasources;

import com.adobe.aem.modernize.dialog.DialogRewriteUtils;
import com.adobe.aem.modernize.dialog.DialogType;
import com.adobe.aem.modernize.impl.RewriteUtils;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.commons.Externalizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"cq/modernize/dialog/datasource"}, methods={"GET"})
public final class DialogsDataSource
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(DialogsDataSource.class);
    private static final String CRX_LITE_PATH = "/crx/de/index";
    @Reference
    private ExpressionResolver expressionResolver;
    @Reference
    private Externalizer externalizer;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Resource resource = request.getResource();
            ResourceResolver resolver = request.getResourceResolver();
            ValueMap properties = resource.getValueMap();
            String itemResourceType = (String)properties.get("itemResourceType", String.class);
            String path = (String)properties.get("path", String.class);
            path = (String)this.expressionResolver.resolve(path, request.getLocale(), String.class, request);
            if (StringUtils.isEmpty((CharSequence)path)) {
                log.warn("Path unavailable");
                return;
            }
            this.setDataSource(resource, path, resolver, request, itemResourceType);
        }
        catch (RepositoryException e) {
            log.warn("Unable to list classic dialogs", (Object)e.getMessage());
        }
    }

    private void setDataSource(Resource resource, String path, ResourceResolver resourceResolver, SlingHttpServletRequest request, String itemResourceType) throws RepositoryException {
        ArrayList<ValueMapResource> resources = new ArrayList<ValueMapResource>();
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            Node node;
            DialogType type;
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            TreeMap<String, Node> nodeMap = new TreeMap<String, Node>();
            if (!(path = path.trim()).startsWith("/")) {
                path = "/" + path;
            }
            if (session.nodeExists(path) && (type = DialogRewriteUtils.getDialogType(node = session.getNode(path))) != DialogType.UNKNOWN && type != DialogType.CORAL_3) {
                nodeMap.put(node.getPath(), node);
            }
            if (nodeMap.isEmpty()) {
                String encodedPath = RewriteUtils.encodePath(path);
                String classicStatement = "SELECT * FROM [cq:Dialog] AS s WHERE ISDESCENDANTNODE(s, '" + encodedPath + "') AND NAME() IN ('" + "dialog" + "', '" + "design_dialog" + "')";
                String coral2Statement = "SELECT parent.* FROM [nt:unstructured] AS parent INNER JOIN [nt:unstructured] AS child on ISCHILDNODE(child, parent) WHERE ISDESCENDANTNODE(parent, '" + encodedPath + "') AND NAME(parent) IN ('" + "cq:dialog" + "', '" + "cq:dialog" + ".coral2" + "', '" + "cq:design_dialog" + "', '" + "cq:design_dialog" + ".coral2" + "') AND NAME(child) = 'content' AND child.[sling:resourceType] NOT LIKE '" + "granite/ui/components/coral/foundation" + "%'";
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                ArrayList<Query> queries = new ArrayList<Query>();
                queries.add(queryManager.createQuery(classicStatement, "JCR-SQL2"));
                queries.add(queryManager.createQuery(coral2Statement, "JCR-SQL2"));
                for (Query query : queries) {
                    NodeIterator iterator = query.execute().getNodes();
                    while (iterator.hasNext()) {
                        String key;
                        Node node2 = iterator.nextNode();
                        Node parent = node2.getParent();
                        if (parent == null) continue;
                        String string = key = DialogRewriteUtils.isDesignDialog(node2) ? parent.getPath() + "/" + "design_dialog" : parent.getPath();
                        if (node2.getName().endsWith(".coral2") && nodeMap.get(key) != null) continue;
                        nodeMap.put(key, node2);
                    }
                }
            }
            int index = 0;
            for (Map.Entry entry : nodeMap.entrySet()) {
                Node parent;
                Node dialog = (Node)entry.getValue();
                if (dialog == null || (parent = dialog.getParent()) == null) continue;
                DialogType dialogType = DialogRewriteUtils.getDialogType(dialog);
                String dialogPath = dialog.getPath();
                String type2 = dialogType.getString();
                String href = this.externalizer.relativeLink(request, dialogPath) + ".html";
                String crxHref = this.externalizer.relativeLink(request, CRX_LITE_PATH) + ".jsp#" + dialogPath;
                boolean isDesignDialog = DialogRewriteUtils.isDesignDialog(dialog);
                if (dialogType == DialogType.CORAL_2 && dialog.getName().endsWith(".coral2") && (!isDesignDialog && !parent.hasNode("cq:dialog") || isDesignDialog && !parent.hasNode("cq:design_dialog"))) continue;
                boolean converted = false;
                if (dialogType == DialogType.CLASSIC) {
                    converted = isDesignDialog ? parent.hasNode("cq:design_dialog") : parent.hasNode("cq:dialog");
                } else if (dialogType == DialogType.CORAL_2) {
                    converted = dialog.getName().endsWith(".coral2");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dialogPath", dialogPath);
                map.put("type", type2);
                map.put("href", href);
                map.put("converted", converted);
                map.put("crxHref", crxHref);
                if (converted) {
                    Node convertedNode = isDesignDialog ? parent.getNode("cq:design_dialog") : parent.getNode("cq:dialog");
                    String touchHref = this.externalizer.relativeLink(request, convertedNode.getPath()) + ".html";
                    String touchCrxHref = this.externalizer.relativeLink(request, CRX_LITE_PATH) + ".jsp#" + convertedNode.getPath().replaceAll(":", "%3A");
                    map.put("touchHref", touchHref);
                    map.put("touchCrxHref", touchCrxHref);
                }
                resources.add(new ValueMapResource(resourceResolver, resource.getPath() + "/dialog_" + index, itemResourceType, (ValueMap)new ValueMapDecorator(map)));
                ++index;
            }
        }
        SimpleDataSource ds = new SimpleDataSource(resources.iterator());
        request.setAttribute(DataSource.class.getName(), (Object)ds);
    }

    protected void bindExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    protected void unbindExpressionResolver(ExpressionResolver expressionResolver) {
        if (this.expressionResolver == expressionResolver) {
            this.expressionResolver = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

