/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.dialog.impl;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.dialog.DialogRewriteRule;
import com.adobe.aem.modernize.dialog.impl.DialogTreeRewriter;
import com.adobe.aem.modernize.dialog.impl.rules.NodeBasedDialogRewriteRule;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, paths={"/libs/cq/modernize/dialog/content/convert"}, extensions={"json"})
public class DialogConversionServlet
extends SlingAllMethodsServlet {
    public static final String RULES_SEARCH_PATH = "cq/modernize/dialog/rules";
    public static final String PARAM_PATHS = "paths";
    private static final String KEY_RESULT_PATH = "resultPath";
    private static final String KEY_ERROR_MESSAGE = "errorMessage";
    private Logger logger = LoggerFactory.getLogger(DialogConversionServlet.class);
    @Reference(referenceInterface=DialogRewriteRule.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindRule", unbind="unbindRule")
    private List<DialogRewriteRule> rules = Collections.synchronizedList(new LinkedList());

    public void bindRule(DialogRewriteRule rule) {
        this.rules.add(rule);
    }

    public void unbindRule(DialogRewriteRule rule) {
        this.rules.remove(rule);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestParameter[] paths = request.getRequestParameters(PARAM_PATHS);
        if (paths == null) {
            this.logger.warn("Missing parameter 'paths'");
            response.setContentType("text/html");
            response.getWriter().println("Missing parameter 'paths'");
            response.setStatus(400);
            return;
        }
        List<DialogRewriteRule> rules = this.getRules(request.getResourceResolver());
        long tick = System.currentTimeMillis();
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        DialogTreeRewriter rewriter = new DialogTreeRewriter(rules);
        JSONObject results = new JSONObject();
        this.logger.debug("Converting {} dialogs", (Object)paths.length);
        try {
            for (RequestParameter parameter : paths) {
                String path = parameter.getString();
                JSONObject json = new JSONObject();
                results.put(path, (Object)json);
                if (!session.nodeExists(path)) {
                    json.put(KEY_ERROR_MESSAGE, (Object)"Invalid path");
                    this.logger.debug("Path {} doesn't exist", (Object)path);
                    continue;
                }
                try {
                    Node result = rewriter.rewrite(session.getNode(path));
                    json.put(KEY_RESULT_PATH, (Object)result.getPath());
                    this.logger.debug("Successfully converted dialog {} to {}", (Object)path, (Object)result.getPath());
                }
                catch (RewriteException e) {
                    json.put(KEY_ERROR_MESSAGE, (Object)e.getMessage());
                    this.logger.warn("Converting dialog {} failed", (Object)path, (Object)e);
                }
            }
            response.setContentType("application/json");
            response.getWriter().write(results.toString());
            long tack = System.currentTimeMillis();
            this.logger.debug("Rewrote {} dialogs in {} ms", (Object)paths.length, (Object)(tack - tick));
        }
        catch (Exception e) {
            throw new ServletException("Caught exception while rewriting dialogs", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DialogRewriteRule> getRules(ResourceResolver resolver) throws ServletException {
        LinkedList<DialogRewriteRule> rules = new LinkedList<DialogRewriteRule>();
        List<DialogRewriteRule> list = this.rules;
        synchronized (list) {
            rules.addAll(this.rules);
        }
        int nb = rules.size();
        Resource resource = resolver.getResource(RULES_SEARCH_PATH);
        if (resource != null) {
            try {
                Node rulesContainer = (Node)resource.adaptTo(Node.class);
                NodeIterator iterator = rulesContainer.getNodes();
                while (iterator.hasNext()) {
                    Node nextNode = iterator.nextNode();
                    if (this.isFolder(nextNode)) {
                        NodeIterator nodeIterator = nextNode.getNodes();
                        while (nodeIterator.hasNext()) {
                            Node nestedNode = nodeIterator.nextNode();
                            if (this.isFolder(nestedNode)) continue;
                            rules.add(new NodeBasedDialogRewriteRule(nestedNode));
                        }
                        continue;
                    }
                    rules.add(new NodeBasedDialogRewriteRule(nextNode));
                }
            }
            catch (RepositoryException e) {
                throw new ServletException("Caught exception while collecting rewrite rules", (Throwable)e);
            }
        }
        Collections.sort(rules, new RuleComparator());
        this.logger.debug("Found {} rules ({} Java-based, {} node-based)", (Object)nb, (Object)(rules.size() - nb));
        for (DialogRewriteRule rule : rules) {
            this.logger.debug(rule.toString());
        }
        return rules;
    }

    private boolean isFolder(Node node) throws RepositoryException {
        String primaryType = node.getPrimaryNodeType().getName();
        return primaryType.equals("sling:Folder") || primaryType.equals("sling:OrderedFolder") || primaryType.equals("nt:folder");
    }

    private class RuleComparator
    implements Comparator<DialogRewriteRule> {
        private RuleComparator() {
        }

        @Override
        public int compare(DialogRewriteRule rule1, DialogRewriteRule rule2) {
            int ranking1 = rule1.getRanking();
            int ranking2 = rule2.getRanking();
            return Double.compare(ranking1, ranking2);
        }
    }
}

