/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.dialog.impl;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.dialog.DialogRewriteRule;
import com.adobe.aem.modernize.dialog.DialogRewriteUtils;
import com.adobe.aem.modernize.dialog.DialogType;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.flat.TreeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogTreeRewriter {
    private Logger logger = LoggerFactory.getLogger(DialogTreeRewriter.class);
    private List<DialogRewriteRule> rules;

    public DialogTreeRewriter(List<DialogRewriteRule> rules) {
        this.rules = rules;
    }

    private void check(Node root) throws RewriteException, RepositoryException {
        DialogType type = DialogRewriteUtils.getDialogType(root);
        if (type == DialogType.UNKNOWN || type == DialogType.CORAL_3) {
            this.logger.debug("{} is not a Classic (cq:Dialog) or Coral 2 dialog", (Object)root.getPath());
            throw new RewriteException("Node is not a Classic (cq:Dialog) or Coral 2 dialog");
        }
        if (type == DialogType.CLASSIC) {
            boolean isDesignDialog = DialogRewriteUtils.isDesignDialog(root);
            Node conversion = null;
            if (isDesignDialog) {
                if (root.getParent().hasNode("cq:design_dialog")) {
                    conversion = root.getParent().getNode("cq:design_dialog");
                }
            } else if (root.getParent().hasNode("cq:dialog")) {
                conversion = root.getParent().getNode("cq:dialog");
            }
            if (conversion != null && (type = DialogRewriteUtils.getDialogType(conversion)) == DialogType.CORAL_3) {
                this.logger.debug("Dialog {} already has a Coral 3 counterpart", (Object)root.getPath());
                throw new RewriteException("Coral 3 dialog already exists");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node rewrite(Node root) throws RewriteException, RepositoryException {
        this.logger.debug("Rewriting dialog tree rooted at {}", (Object)root.getPath());
        this.check(root);
        DialogType type = DialogRewriteUtils.getDialogType(root);
        String name = "";
        if (type == DialogType.CORAL_2) {
            name = root.getName() + ".coral2";
            Node parent = root.getParent();
            if (parent != null && parent.hasNode(name)) {
                parent.getNode(name).remove();
            }
        } else {
            name = JcrUtil.createValidChildName((Node)root.getParent(), (String)root.getName());
        }
        Node copy = JcrUtil.copy((Node)root, (Node)root.getParent(), (String)name);
        long tick = System.currentTimeMillis();
        Session session = root.getSession();
        Node startNode = type == DialogType.CORAL_2 ? root : copy;
        boolean success = false;
        LinkedHashSet<String> finalPaths = new LinkedHashSet<String>();
        try {
            boolean foundMatch;
            do {
                foundMatch = false;
                TreeTraverser traverser = new TreeTraverser(startNode);
                Iterator iterator = traverser.iterator();
                this.logger.debug("Starting new pre-order tree traversal");
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    if (node.getParent().getPrimaryNodeType().hasOrderableChildNodes()) {
                        node.getParent().orderBefore(node.getName(), null);
                    }
                    if (foundMatch || finalPaths.contains(node.getPath())) continue;
                    LinkedHashSet<Node> finalNodes = new LinkedHashSet<Node>();
                    for (DialogRewriteRule rule : this.rules) {
                        if (!rule.matches(node)) continue;
                        this.logger.debug("Rule {} matched subtree rooted at {}", (Object)rule, (Object)node.getPath());
                        Node result = rule.applyTo(node, finalNodes);
                        if (node.equals(startNode)) {
                            startNode = result;
                        }
                        this.addPaths(finalPaths, finalNodes);
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    finalNodes.add(node);
                    this.addPaths(finalPaths, finalNodes);
                }
            } while (foundMatch && startNode != null);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    session.refresh(false);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Could not revert changes", (Throwable)e);
                }
            }
        }
        session.save();
        long tack = System.currentTimeMillis();
        this.logger.debug("Rewrote dialog tree rooted at {} in {} ms", (Object)root.getPath(), (Object)(tack - tick));
        return startNode;
    }

    private void addPaths(Set<String> paths, Set<Node> nodes) throws RepositoryException {
        for (Node node : nodes) {
            paths.add(node.getPath());
        }
    }
}

