/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.dialog.impl.rules;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.dialog.AbstractDialogRewriteRule;
import com.adobe.aem.modernize.dialog.DialogRewriteUtils;
import com.adobe.aem.modernize.impl.RewriteUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
@Properties(value={@Property(name="service.ranking", intValue={1})})
public class CqDialogRewriteRule
extends AbstractDialogRewriteRule {
    @Override
    public boolean matches(Node root) throws RepositoryException {
        return RewriteUtils.hasPrimaryType(root, "cq:Dialog");
    }

    @Override
    public Node applyTo(Node root, Set<Node> finalNodes) throws RewriteException, RepositoryException {
        Node parent = root.getParent();
        boolean isDesignDialog = root.getName().contains("design_dialog");
        if (isDesignDialog) {
            if (parent.hasNode("cq:design_dialog")) {
                throw new RewriteException("Could not rewrite dialog: cq:design_dialog node already exists");
            }
        } else if (parent.hasNode("cq:dialog")) {
            throw new RewriteException("Could not rewrite dialog: cq:dialog node already exists");
        }
        boolean isTabbed = this.isTabbed(root);
        Node dialogItems = this.getDialogItems(root);
        if (dialogItems == null) {
            throw new RewriteException("Unable to find the dialog items");
        }
        Node cqDialog = isDesignDialog ? parent.addNode("cq:design_dialog", "nt:unstructured") : parent.addNode("cq:dialog", "nt:unstructured");
        finalNodes.add(cqDialog);
        cqDialog.setProperty("sling:resourceType", "cq/gui/components/authoring/dialog");
        if (root.hasProperty("helpPath")) {
            cqDialog.setProperty("helpPath", root.getProperty("helpPath").getValue());
        }
        if (root.hasProperty("title")) {
            cqDialog.setProperty("jcr:title", root.getProperty("title").getValue());
        }
        String nodeType = isTabbed ? "cq:TabPanel" : "cq:Panel";
        Node content = cqDialog.addNode("content", nodeType);
        Node items = content.addNode("items", "cq:WidgetCollection");
        NodeIterator iterator = dialogItems.getNodes();
        while (iterator.hasNext()) {
            Node item = iterator.nextNode();
            JcrUtil.copy((Node)item, (Node)items, (String)item.getName());
        }
        root.remove();
        return cqDialog;
    }

    private boolean isTabbed(Node dialog) throws RepositoryException {
        if (this.isTabPanel(dialog)) {
            return true;
        }
        Node items = this.getChild(dialog, "items");
        if (this.isTabPanel(items)) {
            return true;
        }
        return items != null && this.isTabPanel(this.getChild(items, "tabs"));
    }

    private Node getDialogItems(Node dialog) throws RepositoryException {
        Node items = dialog;
        while ((items = this.getChild(items, "items")) != null && !"cq:WidgetCollection".equals(items.getPrimaryNodeType().getName())) {
        }
        if (items == null) {
            return null;
        }
        Node tabs = this.getChild(items, "tabs");
        if (tabs != null && this.isTabPanel(tabs)) {
            return this.getChild(tabs, "items");
        }
        return items;
    }

    private Node getChild(Node node, String name) throws RepositoryException {
        if (node.hasNode(name)) {
            return node.getNode(name);
        }
        return null;
    }

    private boolean isTabPanel(Node node) throws RepositoryException {
        if (node == null) {
            return false;
        }
        if ("cq:TabPanel".equals(node.getPrimaryNodeType().getName())) {
            return true;
        }
        return DialogRewriteUtils.hasXtype(node, "tabpanel");
    }
}

