/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.dialog.impl.rules;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.dialog.AbstractDialogRewriteRule;
import com.adobe.aem.modernize.dialog.DialogRewriteUtils;
import com.adobe.aem.modernize.impl.RewriteUtils;
import com.day.cq.commons.PathInfo;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
@Properties(value={@Property(name="service.ranking", intValue={2})})
public class IncludeRewriteRule
extends AbstractDialogRewriteRule {
    private static final String XTYPE = "cqinclude";

    @Override
    public boolean matches(Node root) throws RepositoryException {
        return DialogRewriteUtils.hasXtype(root, XTYPE);
    }

    @Override
    public Node applyTo(Node root, Set<Node> finalNodes) throws RewriteException, RepositoryException {
        if (!root.hasProperty("path")) {
            throw new RewriteException("Missing include path");
        }
        PathInfo info = new PathInfo(root.getProperty("path").getString());
        String path = info.getResourcePath();
        Session session = root.getSession();
        if (!session.nodeExists(path)) {
            throw new RewriteException("Include path does not exist");
        }
        Node parent = root.getParent();
        String name = root.getName();
        root.remove();
        Node node = session.getNode(path);
        if (RewriteUtils.hasPrimaryType(node, "cq:WidgetCollection")) {
            NodeIterator iterator = node.getNodes();
            Node newRoot = null;
            while (iterator.hasNext()) {
                Node item = iterator.nextNode();
                Node copy = JcrUtil.copy((Node)item, (Node)parent, (String)JcrUtil.createValidChildName((Node)parent, (String)item.getName()));
                if (newRoot != null) continue;
                newRoot = copy;
            }
            return newRoot;
        }
        return JcrUtil.copy((Node)session.getNode(path), (Node)parent, (String)name);
    }
}

