/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.dialog.impl.rules;

import com.adobe.aem.modernize.dialog.AbstractDialogRewriteRule;
import com.adobe.aem.modernize.dialog.DialogRewriteUtils;
import com.adobe.aem.modernize.impl.RewriteUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class MultifieldRewriteRule
extends AbstractDialogRewriteRule {
    private static final String XTYPE = "multifield";
    private static final String GRANITEUI_MULTIFIELD_RT = "granite/ui/components/coral/foundation/form/multifield";
    private static final String GRANITEUI_TEXTFIELD_RT = "granite/ui/components/coral/foundation/form/textfield";

    @Override
    public boolean matches(Node root) throws RepositoryException {
        return DialogRewriteUtils.hasXtype(root, XTYPE);
    }

    @Override
    public Node applyTo(Node root, Set<Node> finalNodes) throws RepositoryException {
        Node parent = root.getParent();
        String name = root.getName();
        RewriteUtils.rename(root);
        Node newRoot = parent.addNode(name, "nt:unstructured");
        finalNodes.add(newRoot);
        newRoot.setProperty("sling:resourceType", GRANITEUI_MULTIFIELD_RT);
        DialogRewriteUtils.copyProperty(root, "fieldLabel", newRoot, "fieldLabel");
        DialogRewriteUtils.copyProperty(root, "fieldDescription", newRoot, "fieldDescription");
        if (root.hasNode("fieldConfig")) {
            Node field = JcrUtil.copy((Node)root.getNode("fieldConfig"), (Node)newRoot, (String)"field");
            field.setPrimaryType("cq:Widget");
            DialogRewriteUtils.copyProperty(root, "name", field, "name");
        } else {
            Node field = newRoot.addNode("field", "nt:unstructured");
            finalNodes.add(field);
            field.setProperty("sling:resourceType", GRANITEUI_TEXTFIELD_RT);
        }
        root.remove();
        return newRoot;
    }
}

