/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.dialog.impl.rules;

import com.adobe.aem.modernize.dialog.DialogRewriteRule;
import com.adobe.aem.modernize.impl.AbstractNodeBasedRewriteRule;
import com.day.cq.commons.jcr.JcrUtil;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.flat.TreeTraverser;

public class NodeBasedDialogRewriteRule
extends AbstractNodeBasedRewriteRule
implements DialogRewriteRule {
    private static final String PROPERTY_COMMON_ATTRS = "cq:rewriteCommonAttrs";
    private static final String PROPERTY_RENDER_CONDITION = "cq:rewriteRenderCondition";
    private static final String NN_RENDER_CONDITION = "rendercondition";
    private static final String NN_GRANITE_RENDER_CONDITION = "granite:rendercondition";
    private static final String NN_GRANITE_DATA = "granite:data";
    private static final String[] GRANITE_COMMON_ATTR_PROPERTIES = new String[]{"id", "rel", "class", "title", "hidden", "itemscope", "itemtype", "itemprop"};
    private static final String RENDER_CONDITION_CORAL2_RESOURCE_TYPE_PREFIX = "granite/ui/components/foundation/renderconditions";
    private static final String RENDER_CONDITION_CORAL3_RESOURCE_TYPE_PREFIX = "granite/ui/components/coral/foundation/renderconditions";
    private static final String DATA_PREFIX = "data-";

    public NodeBasedDialogRewriteRule(Node ruleNode) {
        super(ruleNode);
    }

    @Override
    public void doAdditionalApplyTo(Node root, Node copy, Node replacementRules) throws RepositoryException {
        if (replacementRules.hasProperty(PROPERTY_COMMON_ATTRS)) {
            this.addCommonAttrMappings(root, copy);
        }
        if (replacementRules.hasProperty(PROPERTY_RENDER_CONDITION) && (root.hasNode(NN_GRANITE_RENDER_CONDITION) || root.hasNode(NN_RENDER_CONDITION))) {
            Node renderConditionRoot = root.hasNode(NN_GRANITE_RENDER_CONDITION) ? root.getNode(NN_GRANITE_RENDER_CONDITION) : root.getNode(NN_RENDER_CONDITION);
            Node renderConditionCopy = JcrUtil.copy((Node)renderConditionRoot, (Node)copy, (String)NN_GRANITE_RENDER_CONDITION);
            TreeTraverser renderConditionTraverser = new TreeTraverser(renderConditionCopy);
            for (Node renderConditionNode : renderConditionTraverser) {
                String resourceType = renderConditionNode.getProperty("sling:resourceType").getString();
                if (!resourceType.startsWith(RENDER_CONDITION_CORAL2_RESOURCE_TYPE_PREFIX)) continue;
                resourceType = resourceType.replace(RENDER_CONDITION_CORAL2_RESOURCE_TYPE_PREFIX, RENDER_CONDITION_CORAL3_RESOURCE_TYPE_PREFIX);
                renderConditionNode.setProperty("sling:resourceType", resourceType);
            }
        }
    }

    private void addCommonAttrMappings(Node root, Node node) throws RepositoryException {
        for (String property : GRANITE_COMMON_ATTR_PROPERTIES) {
            String[] mapping = new String[]{"${./" + property + "}", "${'./granite:" + property + "'}"};
            this.mapProperty(root, node.setProperty("granite:" + property, mapping));
        }
        if (root.hasNode(NN_GRANITE_DATA)) {
            JcrUtil.copy((Node)root.getNode(NN_GRANITE_DATA), (Node)node, (String)NN_GRANITE_DATA);
        }
        PropertyIterator propertyIterator = root.getProperties("data-*");
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            String name = property.getName();
            if (property.getDefinition().isProtected()) continue;
            if (!node.hasNode(NN_GRANITE_DATA)) {
                node.addNode(NN_GRANITE_DATA);
            }
            if (!node.hasNode(NN_GRANITE_DATA)) continue;
            Node dataNode = node.getNode(NN_GRANITE_DATA);
            String nameWithoutPrefix = name.substring(DATA_PREFIX.length());
            this.mapProperty(root, dataNode.setProperty(nameWithoutPrefix, "${./" + name + "}"));
        }
    }
}

