/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.impl;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.RewriteRule;
import com.adobe.aem.modernize.impl.RewriteUtils;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.flat.TreeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeBasedRewriteRule
implements RewriteRule {
    private static final Pattern MAPPED_PATTERN = Pattern.compile("^(\\!{0,1})\\$\\{('.*?'|.*?)(:(.+))?\\}$");
    private static final String PROPERTY_RANKING = "cq:rewriteRanking";
    private static final String PROPERTY_OPTIONAL = "cq:rewriteOptional";
    private static final String PROPERTY_MAP_CHILDREN = "cq:rewriteMapChildren";
    private static final String PROPERTY_IS_FINAL = "cq:rewriteFinal";
    private static final String PROPERTY_ORDER_BEFORE = "cq:orderBefore";
    private static final String PROPERTY_COPY_CHILDREN = "cq:copyChildren";
    private static final String NN_CQ_REWRITE_PROPERTIES = "cq:rewriteProperties";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Node ruleNode;
    private Integer ranking = null;

    public AbstractNodeBasedRewriteRule(Node ruleNode) {
        this.ruleNode = ruleNode;
    }

    @Override
    public boolean matches(Node root) throws RepositoryException {
        if (!this.ruleNode.hasNode("patterns")) {
            return false;
        }
        Node patterns = this.ruleNode.getNode("patterns");
        if (!patterns.hasNodes()) {
            return false;
        }
        NodeIterator iterator = patterns.getNodes();
        while (iterator.hasNext()) {
            Node pattern = iterator.nextNode();
            if (!this.matches(root, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Node root, Node pattern) throws RepositoryException {
        Node child;
        if (!RewriteUtils.hasPrimaryType(root, pattern.getPrimaryNodeType().getName())) {
            return false;
        }
        PropertyIterator propertyIterator = pattern.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            String name = property.getName();
            if (property.getDefinition().isProtected() || PROPERTY_OPTIONAL.equals(name)) continue;
            if (!root.hasProperty(name)) {
                return false;
            }
            if (root.getProperty(name).getValue().equals(property.getValue())) continue;
            return false;
        }
        NodeIterator nodeIterator = pattern.getNodes();
        while (nodeIterator.hasNext()) {
            child = nodeIterator.nextNode();
            if (child.hasProperty(PROPERTY_OPTIONAL) && child.getProperty(PROPERTY_OPTIONAL).getBoolean() || root.hasNode(child.getName())) continue;
            return false;
        }
        nodeIterator = pattern.getNodes();
        while (nodeIterator.hasNext()) {
            child = nodeIterator.nextNode();
            if (child.hasProperty(PROPERTY_OPTIONAL) && child.getProperty(PROPERTY_OPTIONAL).getBoolean() && !root.hasNode(child.getName())) continue;
            return this.matches(root.getNode(child.getName()), child);
        }
        return true;
    }

    @Override
    public Node applyTo(Node root, Set<Node> finalNodes) throws RewriteException, RepositoryException {
        if (!this.ruleNode.hasNode("replacement")) {
            throw new RewriteException("The rule does not define a replacement node");
        }
        Node replacement = this.ruleNode.getNode("replacement");
        if (!replacement.hasNodes()) {
            root.remove();
            return null;
        }
        boolean treeIsFinal = false;
        if (replacement.hasProperty(PROPERTY_IS_FINAL)) {
            treeIsFinal = replacement.getProperty(PROPERTY_IS_FINAL).getBoolean();
        }
        boolean copyChildren = false;
        Node parent = root.getParent();
        String rootName = root.getName();
        RewriteUtils.rename(root);
        Node replacementNext = replacement.getNodes().nextNode();
        Node copy = JcrUtil.copy((Node)replacementNext, (Node)parent, (String)rootName);
        HashMap<String, String> mappings = new HashMap<String, String>();
        HashMap<String, String> mappingOrder = new HashMap<String, String>();
        TreeTraverser traverser = new TreeTraverser(copy);
        for (Node node : traverser) {
            PropertyIterator propertyIterator = node.getProperties();
            Node rewritePropertiesNode = null;
            if (node.hasNode(NN_CQ_REWRITE_PROPERTIES)) {
                rewritePropertiesNode = node.getNode(NN_CQ_REWRITE_PROPERTIES);
            }
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                if (property.getDefinition().isProtected()) continue;
                if (PROPERTY_MAP_CHILDREN.equals(property.getName())) {
                    mappings.put(property.getString(), node.getPath());
                    property.remove();
                    continue;
                }
                if (PROPERTY_ORDER_BEFORE.equals(property.getName())) {
                    mappingOrder.put(node.getName(), property.getString());
                    property.remove();
                    continue;
                }
                if (PROPERTY_IS_FINAL.equals(property.getName())) {
                    if (!treeIsFinal) {
                        finalNodes.add(node);
                    }
                    property.remove();
                    continue;
                }
                if (PROPERTY_COPY_CHILDREN.equals(property.getName())) {
                    copyChildren = property.getBoolean();
                    property.remove();
                    continue;
                }
                Property mappedProperty = this.mapProperty(root, property);
                if (mappedProperty == null || rewritePropertiesNode == null || !rewritePropertiesNode.hasProperty("./" + mappedProperty.getName())) continue;
                this.rewriteProperty(property, rewritePropertiesNode.getProperty("./" + mappedProperty.getName()));
            }
            if (rewritePropertiesNode == null) continue;
            rewritePropertiesNode.remove();
        }
        if (copyChildren || !mappings.isEmpty()) {
            Session session = root.getSession();
            NodeIterator children = root.getNodes();
            while (children.hasNext()) {
                Node child = children.nextNode();
                boolean foundMapping = false;
                for (Map.Entry mapping : mappings.entrySet()) {
                    Node mappedSource;
                    if (!root.hasNode((String)mapping.getKey()) || !(mappedSource = root.getNode((String)mapping.getKey())).getPath().equals(child.getPath())) continue;
                    foundMapping = true;
                    Node destination = session.getNode((String)mapping.getValue());
                    NodeIterator iterator = child.getNodes();
                    while (iterator.hasNext()) {
                        Node n = iterator.nextNode();
                        JcrUtil.copy((Node)n, (Node)destination, (String)n.getName());
                    }
                }
                if (!copyChildren || foundMapping) continue;
                JcrUtil.copy((Node)child, (Node)copy, (String)child.getName());
            }
            for (Map.Entry orderEntry : mappingOrder.entrySet()) {
                copy.orderBefore((String)orderEntry.getKey(), (String)orderEntry.getValue());
            }
        }
        this.doAdditionalApplyTo(root, copy, replacement);
        if (treeIsFinal) {
            traverser = new TreeTraverser(copy);
            Iterator nodeIterator = traverser.iterator();
            while (nodeIterator.hasNext()) {
                finalNodes.add((Node)nodeIterator.next());
            }
        }
        root.remove();
        return copy;
    }

    protected abstract void doAdditionalApplyTo(Node var1, Node var2, Node var3) throws RewriteException, RepositoryException;

    protected Property mapProperty(Node root, Property property) throws RepositoryException {
        if (property.getType() != 1) {
            return null;
        }
        Value[] values = property.isMultiple() ? property.getValues() : new Value[]{property.getValue()};
        boolean deleteProperty = false;
        for (Value value : values) {
            Matcher matcher = MAPPED_PATTERN.matcher(value.getString());
            if (!matcher.matches()) continue;
            deleteProperty = true;
            String path = matcher.group(2);
            if (root.hasProperty(path = StringUtils.removeStart((String)StringUtils.stripEnd((String)path, (String)"'"), (String)"'"))) {
                Property originalProperty = root.getProperty(path);
                String name = property.getName();
                Node parent = property.getParent();
                property.remove();
                Property newProperty = JcrUtil.copy((Property)originalProperty, (Node)parent, (String)name);
                String negate = matcher.group(1);
                if ("!".equals(negate) && originalProperty.getType() == 6) {
                    newProperty.setValue(!newProperty.getBoolean());
                }
                deleteProperty = false;
                break;
            }
            String defaultValue = matcher.group(4);
            if (defaultValue == null) continue;
            if (property.isMultiple()) {
                String name = property.getName();
                Node parent = property.getParent();
                property.remove();
                parent.setProperty(name, defaultValue);
            } else {
                property.setValue(defaultValue);
            }
            deleteProperty = false;
            break;
        }
        if (deleteProperty) {
            property.remove();
            return null;
        }
        return property;
    }

    protected void rewriteProperty(Property property, Property rewriteProperty) throws RepositoryException {
        Value[] rewrite;
        if (property.getType() == 1 && rewriteProperty.isMultiple() && rewriteProperty.getValues().length == 2 && (rewrite = rewriteProperty.getValues())[0].getType() == 1 && rewrite[1].getType() == 1) {
            String pattern = rewrite[0].toString();
            String replacement = rewrite[1].toString();
            Pattern compiledPattern = Pattern.compile(pattern);
            Matcher matcher = compiledPattern.matcher(property.getValue().toString());
            property.setValue(matcher.replaceAll(replacement));
        }
    }

    @Override
    public int getRanking() {
        if (this.ranking == null) {
            try {
                if (this.ruleNode.hasProperty(PROPERTY_RANKING)) {
                    long ranking = this.ruleNode.getProperty(PROPERTY_RANKING).getLong();
                    this.ranking = new Long(ranking).intValue();
                } else {
                    this.ranking = Integer.MAX_VALUE;
                }
            }
            catch (RepositoryException e) {
                this.logger.warn("Caught exception while reading the cq:rewriteRanking property");
            }
        }
        return this.ranking;
    }

    protected Node getRuleNode() {
        return this.ruleNode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        Object path = null;
        try {
            sb.append("path=").append(this.ruleNode.getPath()).append(",");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        sb.append("ranking=").append(this.getRanking());
        sb.append("]");
        return sb.toString();
    }
}

