/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.text.ISO9075;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;

public class RewriteUtils {
    public static final String RESPONSIVE_GRID_RES_TYPE = "wcm/foundation/components/responsivegrid";

    public static boolean hasPrimaryType(Node node, String typeName) throws RepositoryException {
        return typeName != null && typeName.equals(node.getPrimaryNodeType().getName());
    }

    public static void rename(Node node) throws RepositoryException {
        Node destination = node.getParent();
        Session session = node.getSession();
        String tmpName = JcrUtil.createValidChildName((Node)destination, (String)("tmp-" + System.currentTimeMillis()));
        String tmpPath = destination.getPath() + "/" + tmpName;
        session.move(node.getPath(), tmpPath);
    }

    public static Map<String, String> toMap(String[] values, String separator) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (values == null || values.length < 1) {
            return map;
        }
        for (String value : values) {
            String[] tmp = StringUtils.split((String)value, (String)separator, (int)2);
            if (tmp.length != 2 || tmp.length != 2 || StringUtils.stripToNull((String)tmp[0]) == null || StringUtils.stripToNull((String)tmp[1]) == null) continue;
            map.put(StringUtils.trim((String)tmp[0]), StringUtils.trim((String)tmp[1]));
        }
        return map;
    }

    public static String encodePath(String path) {
        String encodedPath;
        String string = encodedPath = "/".equals(path) ? "" : ISO9075.encodePath((String)path);
        if (encodedPath.length() > 1 && encodedPath.endsWith("/")) {
            encodedPath = encodedPath.substring(0, encodedPath.length() - 1);
        }
        return encodedPath;
    }
}

