/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.structure.datasources;

import com.adobe.aem.modernize.impl.RewriteUtils;
import com.adobe.aem.modernize.structure.StructureRewriteRuleService;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.commons.Externalizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"cq/modernize/templatestructure/datasource"}, methods={"GET"})
public final class PageDataSource
extends SlingSafeMethodsServlet {
    private static final Logger logger = LoggerFactory.getLogger(PageDataSource.class);
    private static final String CRX_LITE_PATH = "/crx/de/index";
    @Reference
    private ExpressionResolver expressionResolver;
    @Reference
    private Externalizer externalizer;
    @Reference
    private StructureRewriteRuleService structureRewriteRuleService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Resource resource = request.getResource();
            ValueMap properties = resource.getValueMap();
            String itemResourceType = (String)properties.get("itemResourceType", String.class);
            String path = (String)properties.get("path", String.class);
            path = (String)this.expressionResolver.resolve(path, request.getLocale(), String.class, request);
            if (StringUtils.isEmpty((CharSequence)path)) {
                logger.warn("Path unavailable");
                return;
            }
            this.setDataSource(path, request, itemResourceType);
        }
        catch (RepositoryException e) {
            logger.warn("Unable to list components: {}", (Object)e.getMessage());
        }
    }

    private void setDataSource(String searchPath, SlingHttpServletRequest request, String itemResourceType) throws RepositoryException {
        List<Resource> resources = this.buildResources(searchPath, request, itemResourceType);
        SimpleDataSource ds = new SimpleDataSource(resources.iterator());
        request.setAttribute(DataSource.class.getName(), (Object)ds);
    }

    private List<Resource> buildResources(String searchPath, SlingHttpServletRequest request, String itemResourceType) throws RepositoryException {
        Query query = this.createQuery(searchPath, request.getResourceResolver());
        NodeIterator it = query.execute().getNodes();
        int index = 0;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        while (it.hasNext()) {
            Node pageContent = it.nextNode();
            String pagePath = pageContent.getPath();
            String href = this.externalizer.relativeLink(request, pageContent.getParent().getPath()) + ".html";
            String crxHref = this.externalizer.relativeLink(request, CRX_LITE_PATH) + ".jsp#" + pageContent.getPath();
            String title = "";
            if (pageContent.hasProperty("jcr:title")) {
                title = pageContent.getProperty("jcr:title").getString();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("title", title);
            map.put("pagePath", pagePath);
            map.put("templateType", pageContent.getProperty("cq:template").getString());
            map.put("href", href);
            map.put("crxHref", crxHref);
            resources.add((Resource)new ValueMapResource(request.getResourceResolver(), request.getResource() + "/page" + index, itemResourceType, (ValueMap)new ValueMapDecorator(map)));
            ++index;
        }
        return resources;
    }

    private Query createQuery(String searchPath, ResourceResolver resolver) throws RepositoryException {
        String encodedPath = RewriteUtils.encodePath(searchPath);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM [cq:PageContent] AS pc ");
        sb.append("WHERE ISDESCENDANTNODE(pc, '").append(encodedPath).append("') ");
        sb.append("AND pc.[cq:template] IN (");
        Iterator<String> it = this.structureRewriteRuleService.getTemplates().iterator();
        while (it.hasNext()) {
            sb.append("'").append(it.next()).append("'");
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        Session session = (Session)resolver.adaptTo(Session.class);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return queryManager.createQuery(sb.toString(), "JCR-SQL2");
    }

    protected void bindExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    protected void unbindExpressionResolver(ExpressionResolver expressionResolver) {
        if (this.expressionResolver == expressionResolver) {
            this.expressionResolver = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindStructureRewriteRuleService(StructureRewriteRuleService structureRewriteRuleService) {
        this.structureRewriteRuleService = structureRewriteRuleService;
    }

    protected void unbindStructureRewriteRuleService(StructureRewriteRuleService structureRewriteRuleService) {
        if (this.structureRewriteRuleService == structureRewriteRuleService) {
            this.structureRewriteRuleService = null;
        }
    }
}

