/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.structure.impl;

import com.adobe.aem.modernize.structure.PageStructureRewriteRule;
import com.adobe.aem.modernize.structure.StructureRewriteRule;
import com.adobe.aem.modernize.structure.StructureRewriteRuleService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class StructureRewriteRuleServiceImpl
implements StructureRewriteRuleService {
    private Logger logger = LoggerFactory.getLogger(StructureRewriteRuleServiceImpl.class);
    @Reference(referenceInterface=StructureRewriteRule.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindRule", unbind="unbindRule")
    private List<StructureRewriteRule> rules = Collections.synchronizedList(new LinkedList());
    @Reference(referenceInterface=PageStructureRewriteRule.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindPageRule", unbind="unbindPageRule")
    private List<PageStructureRewriteRule> pageRules = Collections.synchronizedList(new LinkedList());

    public void bindRule(StructureRewriteRule rule) {
        this.rules.add(rule);
    }

    public void unbindRule(StructureRewriteRule rule) {
        this.rules.remove(rule);
    }

    public void bindPageRule(PageStructureRewriteRule rule) {
        this.pageRules.add(rule);
    }

    public void unbindPageRule(PageStructureRewriteRule rule) {
        this.pageRules.remove(rule);
    }

    @Override
    public Set<String> getTemplates() {
        HashSet<String> templates = new HashSet<String>(this.pageRules.size());
        for (PageStructureRewriteRule r : this.pageRules) {
            templates.add(r.getStaticTemplate());
        }
        return templates;
    }

    @Override
    public List<StructureRewriteRule> getRules(ResourceResolver resolver) {
        LinkedList<StructureRewriteRule> rulesCopy = new LinkedList<StructureRewriteRule>();
        Iterator<StructureRewriteRule> it = this.rules.iterator();
        while (it.hasNext()) {
            rulesCopy.add(it.next());
        }
        return rulesCopy;
    }
}

