/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.structure.impl;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.structure.StructureRewriteRule;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.flat.TreeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureTreeRewriter {
    private Logger logger = LoggerFactory.getLogger(StructureTreeRewriter.class);
    private List<StructureRewriteRule> rules;

    public StructureTreeRewriter(List<StructureRewriteRule> rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node rewrite(Node root) throws RewriteException, RepositoryException {
        this.logger.debug("Rewriting page's content tree rooted at {}", (Object)root.getPath());
        long tick = System.currentTimeMillis();
        Session session = root.getSession();
        Node startNode = root;
        LinkedHashSet<String> finalPaths = new LinkedHashSet<String>();
        boolean foundMatch = false;
        boolean success = false;
        try {
            do {
                foundMatch = false;
                TreeTraverser traverser = new TreeTraverser(startNode);
                Iterator iterator = traverser.iterator();
                this.logger.debug("Starting new pre-order tree traversal");
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    if (foundMatch || finalPaths.contains(node.getPath())) continue;
                    LinkedHashSet<Node> finalNodes = new LinkedHashSet<Node>();
                    for (StructureRewriteRule rule : this.rules) {
                        if (!rule.matches(node)) continue;
                        this.logger.debug("Rule {} matched subtree rooted at {}", (Object)rule, (Object)node.getPath());
                        Node result = rule.applyTo(node, finalNodes);
                        if (node.equals(startNode)) {
                            startNode = result;
                        }
                        this.addPaths(finalPaths, finalNodes);
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    finalNodes.add(node);
                    this.addPaths(finalPaths, finalNodes);
                }
            } while (foundMatch && startNode != null);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    session.refresh(false);
                }
                catch (RepositoryException e) {
                    this.logger.warn("Could not revert changes", (Throwable)e);
                }
            }
        }
        session.save();
        long tack = System.currentTimeMillis();
        this.logger.debug("Rewrote component tree rooted at {} in {} ms", (Object)root.getPath(), (Object)(tack - tick));
        return startNode;
    }

    private void addPaths(Set<String> paths, Set<Node> nodes) throws RepositoryException {
        for (Node node : nodes) {
            paths.add(node.getPath());
        }
    }
}

