/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.structure.impl.rules;

import com.adobe.aem.modernize.RewriteException;
import com.adobe.aem.modernize.structure.StructureRewriteRule;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.Dictionary;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Column Control Rewrite Rule", description="Rewrites Column control components to responsive grid replacements.")
@Properties(value={@Property(name="service.ranking", intValue={3})})
public class ColumnControlRewriteRule
implements StructureRewriteRule {
    private static final Logger logger = LoggerFactory.getLogger(ColumnControlRewriteRule.class);
    private int ranking = Integer.MAX_VALUE;
    private static final String PROP_LAYOUT = "layout";
    private static final String PROP_CONTROL_TYPE = "controlType";
    private static final String CONTROL_TYPE_BREAK = "break";
    private static final String CONTROL_TYPE_END = "end";
    private static final String RESPONSIVE_GRID_NAME = "responsivegrid";
    private static final String DEFAULT_LAYOUT_NAME = "default";
    private static final String PROP_WIDTH = "width";
    private static final String PROP_OFFSET = "offset";
    private static final String PROP_RESOURCE_TYPE_DEFAULT = "foundation/components/parsys/colctrl";
    @Property(label="Column Control ResourceType", description="The sling:resourceType of this column control, leave blank to use Foundation component. (some customers extend/create their own)", value={"foundation/components/parsys/colctrl"})
    private static final String PROP_RESOURCE_TYPE = "sling.resourceType";
    private String resourceType = "foundation/components/parsys/colctrl";
    @Property(label="Layout Property Value", description="The value of the `layout` property on the primary column control component.")
    private static final String PROP_LAYOUT_VALUE = "layout.value";
    private String layout;
    @Property(label="Column Widths", description="An array of widths for each of the columns in target grid. (e.g. 50%/50% column control is [6,6] in target grid. 75%/25% => [8,4])", cardinality=0x7FFFFFFF)
    private static final String PROP_COLUMN_WIDTHS = "column.widths";
    private long[] widths;

    @Override
    public boolean matches(Node root) throws RepositoryException {
        Node sibling;
        if (!root.hasProperty("sling:resourceType")) {
            return false;
        }
        javax.jcr.Property prop = root.getProperty("sling:resourceType");
        if (!StringUtils.equals((CharSequence)this.resourceType, (CharSequence)prop.getString())) {
            return false;
        }
        if (!root.hasProperty(PROP_LAYOUT)) {
            return false;
        }
        prop = root.getProperty(PROP_LAYOUT);
        if (!StringUtils.equals((CharSequence)this.layout, (CharSequence)prop.getString())) {
            return false;
        }
        Node parent = root.getParent();
        NodeIterator siblings = parent.getNodes();
        while (siblings.hasNext() && !(sibling = siblings.nextNode()).getName().equals(root.getName())) {
        }
        int count = this.widths.length;
        while (siblings.hasNext()) {
            Node sibling2 = siblings.nextNode();
            if (!sibling2.hasProperty("sling:resourceType") || !StringUtils.equals((CharSequence)sibling2.getProperty("sling:resourceType").getString(), (CharSequence)this.resourceType)) continue;
            if (sibling2.hasProperty(PROP_LAYOUT) && count != 0) {
                return false;
            }
            if (!sibling2.hasProperty(PROP_CONTROL_TYPE) || !StringUtils.equals((CharSequence)sibling2.getProperty(PROP_CONTROL_TYPE).getString(), (CharSequence)CONTROL_TYPE_BREAK) && !StringUtils.equals((CharSequence)sibling2.getProperty(PROP_CONTROL_TYPE).getString(), (CharSequence)CONTROL_TYPE_END)) continue;
            --count;
            if (!StringUtils.equals((CharSequence)sibling2.getProperty(PROP_CONTROL_TYPE).getString(), (CharSequence)CONTROL_TYPE_END)) continue;
            break;
        }
        return count == 0;
    }

    @Override
    public Node applyTo(Node root, Set<Node> finalNodes) throws RewriteException, RepositoryException {
        Node node = null;
        Node parent = root.getParent();
        NodeIterator siblings = parent.getNodes();
        while (siblings.hasNext() && !this.matches(node = siblings.nextNode())) {
        }
        String firstNodeName = null;
        for (int i = 0; i < this.widths.length; ++i) {
            javax.jcr.Property prop;
            String gridName = JcrUtil.createValidChildName((Node)parent, (String)RESPONSIVE_GRID_NAME);
            Node grid = parent.addNode(gridName, "nt:unstructured");
            if (i == 0) {
                firstNodeName = grid.getName();
            }
            parent.orderBefore(grid.getName(), node.getName());
            grid.setProperty("sling:resourceType", "wcm/foundation/components/responsivegrid");
            Node gridConfig = grid.addNode("cq:responsive", "nt:unstructured");
            Node defaultGridStructure = gridConfig.addNode(DEFAULT_LAYOUT_NAME, "nt:unstructured");
            defaultGridStructure.setProperty(PROP_WIDTH, this.widths[i]);
            defaultGridStructure.setProperty(PROP_OFFSET, 0L);
            node.remove();
            while (siblings.hasNext() && !StringUtils.equals((CharSequence)(prop = (node = siblings.nextNode()).getProperty("sling:resourceType")).getString(), (CharSequence)this.resourceType)) {
                JcrUtil.copy((Node)node, (Node)grid, (String)node.getName());
                node.remove();
            }
        }
        node.remove();
        return parent.getNode(firstNodeName);
    }

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException, ConfigurationException {
        Dictionary props = context.getProperties();
        Object ranking = props.get("service.ranking");
        if (ranking != null) {
            try {
                this.ranking = (Integer)ranking;
            }
            catch (ClassCastException e) {
                logger.warn("Found invalid service.ranking value {}", ranking);
            }
        }
        this.resourceType = PropertiesUtil.toString(props.get(PROP_RESOURCE_TYPE), (String)PROP_RESOURCE_TYPE_DEFAULT);
        if (StringUtils.isBlank((CharSequence)this.resourceType)) {
            throw new ConfigurationException(PROP_RESOURCE_TYPE, "Sling Resource Type is required.");
        }
        this.layout = PropertiesUtil.toString(props.get(PROP_LAYOUT_VALUE), null);
        if (StringUtils.isBlank((CharSequence)this.layout)) {
            throw new ConfigurationException(PROP_LAYOUT_VALUE, "Layout value property is required.");
        }
        Object[] widthsStrings = PropertiesUtil.toStringArray(props.get(PROP_COLUMN_WIDTHS), null);
        if (ArrayUtils.isEmpty((Object[])widthsStrings)) {
            throw new ConfigurationException(PROP_COLUMN_WIDTHS, "Column width property is required.");
        }
        this.widths = new long[widthsStrings.length];
        for (int i = 0; i < widthsStrings.length; ++i) {
            try {
                this.widths[i] = Long.parseLong((String)widthsStrings[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationException(PROP_COLUMN_WIDTHS, "Column width values must be of type long.");
            }
        }
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }
}

