/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.modernize.structure.impl.rules;

import com.adobe.aem.modernize.impl.RewriteUtils;
import com.adobe.aem.modernize.structure.PageStructureRewriteRule;
import com.adobe.aem.modernize.structure.StructureRewriteRule;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={PageStructureRewriteRule.class, StructureRewriteRule.class})
@Component(configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Page Rewrite Rule", description="Rewrites a page template & structure to use new responsive grid layout.")
@Properties(value={@Property(name="service.ranking", intValue={1})})
public class PageRewriteRule
implements PageStructureRewriteRule {
    private static final Logger logger = LoggerFactory.getLogger(PageRewriteRule.class);
    @Property(label="Static Template", description="The static template which will be updated by this Page Rewrite Rule")
    private static final String PROP_STATIC_TEMPLATE = "static.template";
    private String staticTemplate;
    @Property(label="Editable Template", description="The value to update the cq:template with, this should be the new Editable Template.")
    private static final String PROP_EDITABLE_TEMPLATE = "editable.template";
    private String editableTemplate;
    @Property(label="Sling Resource Type", description="The value to update the sling:resourceType with, this should be the same as the new Editable Template.")
    private static final String PROP_SLING_RESOURCE_TYPE = "sling.resourceType";
    private String slingResourceType;
    @Property(label="Component Order", cardinality=0x7FFFFFFF, description="Specify the order of the components in the new responsive grid. Any found and unspecified are moved to the end in arbitrary order.")
    private static final String PROP_ORDER_COMPONENTS = "order.components";
    private Map<String, List<String>> componentOrdering = new HashMap<String, List<String>>();
    @Property(label="Remove Components", cardinality=0x7FFFFFFF, description="Specify any components that may exist on the static page that can be removed.")
    private static final String PROP_REMOVE_COMPONENTS = "remove.components";
    private String[] componentsToRemove;
    @Property(label="Rename Components", cardinality=0x7FFFFFFF, description="Specify new name for components as they are moved into the root responsive grid.")
    private static final String PROP_RENAME_COMPONENTS = "rename.components";
    private Map<String, String> componentRenamed;
    private List<String> nested = new ArrayList<String>();
    private int ranking = Integer.MAX_VALUE;
    private static final String RESPONSIVE_GRID_NODE_NAME = "root";

    @Override
    public boolean matches(Node root) throws RepositoryException {
        if (!root.hasProperty("cq:template")) {
            return false;
        }
        String template = root.getProperty("cq:template").getString();
        return StringUtils.equals((CharSequence)this.staticTemplate, (CharSequence)template);
    }

    @Override
    public Node applyTo(Node root, Set<Node> finalNodes) throws RepositoryException {
        if (root.hasProperty("cq:designPath")) {
            root.getProperty("cq:designPath").remove();
        }
        List<String> remove = Arrays.asList(this.componentsToRemove);
        NodeIterator it = root.getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            if (!remove.contains(child.getName())) continue;
            child.remove();
        }
        javax.jcr.Property template = root.getProperty("cq:template");
        template.setValue(this.editableTemplate);
        javax.jcr.Property resourceType = root.getProperty("sling:resourceType");
        resourceType.setValue(this.slingResourceType);
        Node responsiveGrid = root.addNode(RESPONSIVE_GRID_NODE_NAME, "nt:unstructured");
        responsiveGrid.setProperty("sling:resourceType", "wcm/foundation/components/responsivegrid");
        List<String> names = this.moveStructure(root, responsiveGrid, this.nested);
        for (String key : this.componentOrdering.keySet()) {
            Node child;
            if (RESPONSIVE_GRID_NODE_NAME.equals(key)) continue;
            if (!responsiveGrid.hasNode(key)) {
                child = responsiveGrid.addNode(key, "nt:unstructured");
                child.setProperty("sling:resourceType", "wcm/foundation/components/responsivegrid");
            }
            child = responsiveGrid.getNode(key);
            List<String> cn = this.moveStructure(root, child, names);
            this.reorderChildren(cn, this.componentOrdering.get(key), child);
        }
        this.reorderChildren(names, this.componentOrdering.get(RESPONSIVE_GRID_NODE_NAME), responsiveGrid);
        return root;
    }

    private List<String> moveStructure(Node source, Node target, List<String> ignored) throws RepositoryException {
        ArrayList<String> names = new ArrayList<String>();
        NodeIterator children = source.getNodes();
        while (children.hasNext()) {
            Node child = children.nextNode();
            String name = this.componentRenamed.containsKey(child.getName()) ? this.componentRenamed.get(child.getName()) : child.getName();
            if (RESPONSIVE_GRID_NODE_NAME.equals(name) || ignored.contains(name)) continue;
            name = name.replaceFirst(target.getName() + "/", "");
            JcrUtil.copy((Node)child, (Node)target, (String)name);
            names.add(name);
            child.remove();
        }
        return names;
    }

    private void reorderChildren(List<String> names, List<String> order, Node parent) throws RepositoryException {
        ArrayList<String> copy = new ArrayList<String>(order);
        Collections.reverse(copy);
        Iterator oit = copy.iterator();
        String after = null;
        while (oit.hasNext()) {
            String before = (String)oit.next();
            parent.orderBefore(before, after);
            names.remove(before);
            after = before;
        }
        Iterator<String> nit = names.iterator();
        while (nit.hasNext()) {
            parent.orderBefore(nit.next(), null);
        }
    }

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException, ConfigurationException {
        Dictionary props = context.getProperties();
        Object ranking = props.get("service.ranking");
        if (ranking != null) {
            try {
                this.ranking = (Integer)ranking;
            }
            catch (ClassCastException e) {
                logger.warn("Found invalid service.ranking value {}", ranking);
            }
        }
        this.staticTemplate = PropertiesUtil.toString(props.get(PROP_STATIC_TEMPLATE), null);
        if (StringUtils.isBlank((CharSequence)this.staticTemplate)) {
            throw new ConfigurationException(PROP_STATIC_TEMPLATE, "Static template is required.");
        }
        this.editableTemplate = PropertiesUtil.toString(props.get(PROP_EDITABLE_TEMPLATE), null);
        if (StringUtils.isBlank((CharSequence)this.editableTemplate)) {
            throw new ConfigurationException(PROP_EDITABLE_TEMPLATE, "Editable template is required.");
        }
        this.slingResourceType = PropertiesUtil.toString(props.get(PROP_SLING_RESOURCE_TYPE), null);
        if (StringUtils.isBlank((CharSequence)this.slingResourceType)) {
            throw new ConfigurationException(PROP_SLING_RESOURCE_TYPE, "Sling Resource Type is required.");
        }
        String[] orders = PropertiesUtil.toStringArray(props.get(PROP_ORDER_COMPONENTS), (String[])new String[0]);
        for (String o : orders) {
            String value;
            String[] tmp = StringUtils.split((String)o, (String)":", (int)2);
            if (tmp.length < 1) continue;
            if (tmp.length == 2) {
                this.nested.add(tmp[1]);
            }
            String key = tmp.length == 2 ? tmp[0] : RESPONSIVE_GRID_NODE_NAME;
            String string = value = tmp.length == 2 ? tmp[1] : tmp[0];
            if (this.componentOrdering.get(key) == null) {
                this.componentOrdering.put(key, new ArrayList());
            }
            this.componentOrdering.get(key).add(value);
        }
        this.componentsToRemove = PropertiesUtil.toStringArray(props.get(PROP_REMOVE_COMPONENTS), (String[])new String[0]);
        this.componentRenamed = RewriteUtils.toMap(PropertiesUtil.toStringArray(props.get(PROP_RENAME_COMPONENTS), (String[])new String[0]), ":");
        for (String val : this.componentRenamed.values()) {
            if (!val.contains("/")) continue;
            this.nested.add(val);
        }
    }

    @Override
    public String getStaticTemplate() {
        return this.staticTemplate;
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }
}

